/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.loadbalancer.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.loadbalancer.LoadBalancerService;
import org.jclouds.loadbalancer.LoadBalancerServiceContext;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.Utils;

@Singleton
public class LoadBalancerServiceContextImpl<S, A>
implements LoadBalancerServiceContext {
    private final LoadBalancerService loadBalancerService;
    private final RestContext<S, A> providerSpecificContext;
    private final Utils utils;

    @Inject
    public LoadBalancerServiceContextImpl(LoadBalancerService loadBalancerService, Utils utils, RestContext providerSpecificContext) {
        this.utils = utils;
        this.providerSpecificContext = providerSpecificContext;
        this.loadBalancerService = Preconditions.checkNotNull(loadBalancerService, "loadBalancerService");
    }

    @Override
    public <S, A> RestContext<S, A> getProviderSpecificContext() {
        return this.providerSpecificContext;
    }

    @Override
    public void close() {
        this.providerSpecificContext.close();
    }

    @Override
    public LoadBalancerService getLoadBalancerService() {
        return this.loadBalancerService;
    }

    @Override
    public Utils getUtils() {
        return this.utils();
    }

    @Override
    public Utils utils() {
        return this.utils;
    }

    public int hashCode() {
        return this.providerSpecificContext.hashCode();
    }

    public String toString() {
        return this.providerSpecificContext.toString();
    }

    public boolean equals(Object obj) {
        return this.providerSpecificContext.equals(obj);
    }
}

