/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.location.Iso3166;

@Singleton
public class ProvideIso3166CodesByLocationIdViaProperties
implements Provider<Map<String, Set<String>>> {
    private final Injector injector;

    @Inject
    ProvideIso3166CodesByLocationIdViaProperties(Injector injector) {
        this.injector = Preconditions.checkNotNull(injector, "injector");
    }

    @Override
    @Singleton
    @Iso3166
    public Map<String, Set<String>> get() {
        ImmutableMap.Builder<String, ImmutableSet<String>> codes = ImmutableMap.builder();
        for (String key : ImmutableSet.of("jclouds.region", "jclouds.zone")) {
            try {
                String regionString = this.injector.getInstance(Key.get(String.class, (Annotation)Names.named(key + "s")));
                for (String region : Splitter.on(',').split(regionString)) {
                    try {
                        codes.put(region, ImmutableSet.copyOf(Splitter.on(',').split(this.injector.getInstance(Key.get(String.class, (Annotation)Names.named(key + "." + region + "." + "iso3166-codes"))))));
                    }
                    catch (ConfigurationException e) {}
                }
            }
            catch (ConfigurationException e) {
            }
        }
        return codes.build();
    }
}

