/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Map;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;

@Singleton
public class ProvideRegionToURIViaProperties
implements Provider<Map<String, URI>> {
    private final Injector injector;
    private final Multimap<String, String> constants;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    protected ProvideRegionToURIViaProperties(Injector injector, @Named(value="CONSTANTS") Multimap<String, String> constants) {
        this.injector = injector;
        this.constants = constants;
    }

    @Override
    @Singleton
    @Region
    public Map<String, URI> get() {
        try {
            String regionString = this.injector.getInstance(Key.get(String.class, (Annotation)Names.named("jclouds.regions")));
            ImmutableMap.Builder<String, URI> regions = ImmutableMap.builder();
            for (String region : Splitter.on(',').split(regionString)) {
                String regionUri = this.injector.getInstance(Key.get(String.class, (Annotation)Names.named("jclouds.region." + region + "." + "endpoint")));
                for (Map.Entry<String, String> entry : this.constants.entries()) {
                    regionUri = regionUri.replace('{' + entry.getKey() + '}', entry.getValue());
                }
                regions.put(region, URI.create(regionUri));
            }
            return regions.build();
        }
        catch (ConfigurationException e) {
            this.logger.warn("no region name to endpoint mappings configured!", new Object[0]);
            return ImmutableMap.of();
        }
    }
}

