/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Provider;
import org.jclouds.location.Region;

@Singleton
public class RegionToEndpointOrProviderIfNull
implements Function<Object, URI> {
    private final URI defaultUri;
    private final String defaultProvider;
    private final Map<String, URI> regionToEndpoint;

    @Inject
    public RegionToEndpointOrProviderIfNull(@Provider String defaultProvider, @Provider URI defaultUri, @Region Map<String, URI> regionToEndpoint) {
        this.defaultProvider = Preconditions.checkNotNull(defaultProvider, "defaultProvider");
        this.defaultUri = Preconditions.checkNotNull(defaultUri, "defaultUri");
        this.regionToEndpoint = Preconditions.checkNotNull(regionToEndpoint, "regionToEndpoint");
    }

    @Override
    public URI apply(@Nullable Object from) {
        if (from == null || from.equals(this.defaultProvider)) {
            return this.defaultUri;
        }
        Preconditions.checkArgument(from instanceof String, "region is a String argument");
        Preconditions.checkArgument(this.regionToEndpoint.containsKey(from), "requested location %s, which is not in the configured locations: %s", from, this.regionToEndpoint);
        return this.regionToEndpoint.get(from);
    }
}

