/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;

@Singleton
public class JustProvider
implements Supplier<Set<? extends Location>> {
    private final String providerName;
    private final URI endpoint;
    private final Set<String> isoCodes;

    @Inject
    public JustProvider(@Provider String providerName, @Provider URI endpoint, @Iso3166 Set<String> isoCodes) {
        this.providerName = Preconditions.checkNotNull(providerName, "providerName");
        this.endpoint = Preconditions.checkNotNull(endpoint, "endpoint");
        this.isoCodes = Preconditions.checkNotNull(isoCodes, "isoCodes");
    }

    @Override
    public Set<? extends Location> get() {
        return ImmutableSet.of(new LocationBuilder().scope(LocationScope.PROVIDER).id(this.providerName).description(this.endpoint.toASCIIString()).iso3166Codes(this.isoCodes).build());
    }
}

