/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Region;
import org.jclouds.location.functions.ToIdAndScope;
import org.jclouds.location.predicates.LocationPredicates;

@Singleton
public class OnlyLocationOrFirstRegionOptionallyMatchingRegionId
implements Supplier<Location> {
    private final Predicate<Location> locationPredicate;
    private final Supplier<Set<? extends Location>> locationsSupplier;

    @Inject
    OnlyLocationOrFirstRegionOptionallyMatchingRegionId(@Nullable @Region String region, @Memoized Supplier<Set<? extends Location>> locationsSupplier) {
        this.locationPredicate = region == null ? Predicates.or(LocationPredicates.isZone(), LocationPredicates.isRegion()) : LocationPredicates.isZoneOrRegionWhereRegionIdEquals(region);
        this.locationsSupplier = Preconditions.checkNotNull(locationsSupplier, "locationsSupplier");
    }

    @Override
    @Singleton
    public Location get() {
        Set<? extends Location> locations = this.locationsSupplier.get();
        if (this.locationsSupplier.get().size() == 1) {
            return (Location)Iterables.getOnlyElement((Iterable)this.locationsSupplier.get());
        }
        try {
            Location toReturn = Iterables.find(locations, this.locationPredicate);
            return toReturn.getScope() == LocationScope.REGION ? toReturn : toReturn.getParent();
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(String.format("couldn't find region matching %s in %s", this.locationPredicate, Iterables.transform(locations, ToIdAndScope.INSTANCE)));
        }
    }
}

