/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.openstack.filters.AddTimestampQuery;
import org.jclouds.openstack.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.ServerManagement;
import org.jclouds.openstack.nova.domain.Addresses;
import org.jclouds.openstack.nova.domain.Flavor;
import org.jclouds.openstack.nova.domain.FloatingIP;
import org.jclouds.openstack.nova.domain.Image;
import org.jclouds.openstack.nova.domain.RebootType;
import org.jclouds.openstack.nova.domain.Server;
import org.jclouds.openstack.nova.options.CreateServerOptions;
import org.jclouds.openstack.nova.options.ListOptions;
import org.jclouds.openstack.nova.options.RebuildServerOptions;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.functions.ReturnEmptySetOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnFalseOnNotFoundOr404;
import org.jclouds.rest.functions.ReturnNullOnNotFoundOr404;

@SkipEncoding(value={47, 61})
@RequestFilters(value={AuthenticateRequest.class, AddTimestampQuery.class})
@Endpoint(value=ServerManagement.class)
public interface NovaAsyncClient {
    @GET
    @Unwrap
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/servers")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<Server>> listServers(ListOptions ... var1);

    @GET
    @Unwrap
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/servers/{id}")
    public ListenableFuture<Server> getServer(@PathParam(value="id") int var1);

    @GET
    @Unwrap
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @Path(value="/servers/{uuid}")
    public ListenableFuture<Server> getServer(@PathParam(value="uuid") String var1);

    @DELETE
    @Consumes
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    @Path(value="/servers/{id}")
    public ListenableFuture<Boolean> deleteServer(@PathParam(value="id") int var1);

    @DELETE
    @Consumes
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    @Path(value="/servers/{uuid}")
    public ListenableFuture<Boolean> deleteServer(@PathParam(value="uuid") String var1);

    @POST
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"reboot\":%7B\"type\":\"{type}\"%7D%7D")
    public ListenableFuture<Void> rebootServer(@PathParam(value="id") int var1, @PayloadParam(value="type") RebootType var2);

    @POST
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"resize\":%7B\"flavorId\":{flavorId}%7D%7D")
    public ListenableFuture<Void> resizeServer(@PathParam(value="id") int var1, @PayloadParam(value="flavorId") int var2);

    @POST
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="{\"confirmResize\":null}")
    public ListenableFuture<Void> confirmResizeServer(@PathParam(value="id") int var1);

    @POST
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="{\"revertResize\":null}")
    public ListenableFuture<Void> revertResizeServer(@PathParam(value="id") int var1);

    @POST
    @Unwrap
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/servers")
    @MapBinder(value=CreateServerOptions.class)
    public ListenableFuture<Server> createServer(@PayloadParam(value="name") String var1, @PayloadParam(value="imageRef") String var2, @PayloadParam(value="flavorRef") String var3, CreateServerOptions ... var4);

    @POST
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/servers/{id}/action")
    @Consumes
    @MapBinder(value=RebuildServerOptions.class)
    public ListenableFuture<Void> rebuildServer(@PathParam(value="id") int var1, RebuildServerOptions ... var2);

    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"changePassword\":%7B\"adminPass\":\"{adminPass}\"%7D%7D")
    public ListenableFuture<Void> changeAdminPass(@PathParam(value="id") int var1, @PayloadParam(value="adminPass") String var2);

    @PUT
    @Path(value="/servers/{id}")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"server\":%7B\"name\":\"{name}\"%7D%7D")
    public ListenableFuture<Void> renameServer(@PathParam(value="id") int var1, @PayloadParam(value="name") String var2);

    @GET
    @Unwrap
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/flavors")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<Flavor>> listFlavors(ListOptions ... var1);

    @GET
    @Unwrap
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/flavors/{id}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Flavor> getFlavor(@PathParam(value="id") int var1);

    @GET
    @Unwrap
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/flavors/{uuid}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<Flavor> getFlavor(@PathParam(value="uuid") String var1);

    @GET
    @Unwrap
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/images")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<Image>> listImages(ListOptions ... var1);

    @GET
    @Unwrap
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/images/{id}")
    public ListenableFuture<Image> getImage(@PathParam(value="id") int var1);

    @GET
    @Unwrap
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/images/{uuid}")
    public ListenableFuture<Image> getImage(@PathParam(value="uuid") String var1);

    @DELETE
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    @Consumes
    @Path(value="/images/{id}")
    public ListenableFuture<Boolean> deleteImage(@PathParam(value="id") int var1);

    @DELETE
    @ExceptionParser(value=ReturnFalseOnNotFoundOr404.class)
    @Consumes
    @Path(value="/images/{id}")
    public ListenableFuture<Boolean> deleteImage(@PathParam(value="id") String var1);

    @POST
    @Unwrap
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/images")
    @Produces(value={"application/json"})
    @Payload(value="%7B\"image\":%7B\"serverId\":{serverId},\"name\":\"{name}\"%7D%7D")
    public ListenableFuture<Image> createImageFromServer(@PayloadParam(value="name") String var1, @PayloadParam(value="serverId") int var2);

    @GET
    @Unwrap
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/servers/{id}/ips")
    public ListenableFuture<Addresses> getAddresses(@PathParam(value="id") int var1);

    @GET
    @Unwrap
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/servers/{id}/ips/public")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<String>> listPublicAddresses(@PathParam(value="id") int var1);

    @GET
    @Unwrap
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/servers/{id}/ips/private")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<String>> listPrivateAddresses(@PathParam(value="id") int var1);

    @POST
    @Path(value="/servers/{id}/action")
    @Consumes
    @Produces(value={"application/json"})
    @Payload(value="%7B\"addFloatingIp\":%7B\"address\":\"{address}\"%7D%7D")
    public ListenableFuture<Void> addFloatingIP(@PathParam(value="id") int var1, @PayloadParam(value="address") String var2);

    @GET
    @Unwrap
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/os-floating-ips")
    @ExceptionParser(value=ReturnEmptySetOnNotFoundOr404.class)
    public ListenableFuture<? extends Set<FloatingIP>> listFloatingIPs();

    @GET
    @Unwrap
    @Consumes(value={"application/json"})
    @QueryParams(keys={"format"}, values={"json"})
    @Path(value="/os-floating-ips/{id}")
    @ExceptionParser(value=ReturnNullOnNotFoundOr404.class)
    public ListenableFuture<FloatingIP> getFloatingIP(@PathParam(value="id") int var1);
}

