/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.compute.functions;

import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.openstack.nova.domain.Image;

@Singleton
public class NovaImageToImage
implements Function<Image, org.jclouds.compute.domain.Image> {
    private final Function<Image, OperatingSystem> imageToOs;

    @Inject
    NovaImageToImage(Function<Image, OperatingSystem> imageToOs) {
        this.imageToOs = imageToOs;
    }

    @Override
    public org.jclouds.compute.domain.Image apply(Image from) {
        ImageBuilder builder = new ImageBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getName() != null ? from.getName() : "unspecified");
        builder.description(from.getName() != null ? from.getName() : "unspecified");
        builder.version(from.getUpdated() != null ? from.getUpdated().getTime() + "" : "-1");
        builder.operatingSystem(this.imageToOs.apply(from));
        builder.uri(from.getURI());
        org.jclouds.compute.domain.Image image = builder.build();
        return image;
    }
}

