/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.config;

import com.google.inject.Provides;
import java.net.URI;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.OpenStackAuthAsyncClient;
import org.jclouds.openstack.config.OpenStackAuthenticationModule;
import org.jclouds.openstack.handlers.RetryOnRenew;
import org.jclouds.openstack.nova.NovaAsyncClient;
import org.jclouds.openstack.nova.NovaClient;
import org.jclouds.openstack.nova.ServerManagement;
import org.jclouds.openstack.nova.handlers.ParseNovaErrorFromHttpResponse;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
@RequiresHttp
public class NovaRestClientModule
extends RestClientModule<NovaClient, NovaAsyncClient> {
    private final OpenStackAuthenticationModule module;

    public NovaRestClientModule(OpenStackAuthenticationModule module) {
        super(NovaClient.class, NovaAsyncClient.class);
        this.module = module;
    }

    public NovaRestClientModule() {
        this(new OpenStackAuthenticationModule());
    }

    @Override
    protected void configure() {
        this.install(this.module);
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        super.configure();
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseNovaErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseNovaErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseNovaErrorFromHttpResponse.class);
    }

    @Override
    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(RetryOnRenew.class);
    }

    @Provides
    @Singleton
    @ServerManagement
    protected URI provideServerUrl(OpenStackAuthAsyncClient.AuthenticationResponse response) {
        return response.getServices().get("X-Server-Management-Url");
    }
}

