/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.domain;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.jclouds.openstack.nova.domain.ImageStatus;
import org.jclouds.openstack.nova.domain.Resource;

public class Image
extends Resource {
    private int id;
    private String name;
    private Integer progress;
    private String serverRef;
    private ImageStatus status;
    private Map<String, String> metadata = Maps.newHashMap();
    private Date created;
    private Date updated;

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public Image() {
    }

    public Image(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setProgress(Integer progress) {
        this.progress = progress;
    }

    public Integer getProgress() {
        return this.progress;
    }

    public void setServerRef(String serverRef) {
        this.serverRef = serverRef;
    }

    public String getServerRef() {
        return this.serverRef;
    }

    public void setStatus(ImageStatus status) {
        this.status = status;
    }

    public ImageStatus getStatus() {
        return this.status;
    }

    public Map<String, String> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = Maps.newHashMap(metadata);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.serverRef == null ? 0 : this.serverRef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Image other = (Image)obj;
        if (this.id != other.id) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "Image [created=" + this.getCreated() + ", id=" + this.id + ", name=" + this.name + ", serverRef=" + this.serverRef + "]";
    }
}

