/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.internal.BaseAsyncBlobStore;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.blobstore.strategy.internal.FetchBlobMetadata;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.blobstore.util.BlobUtils;
import org.jclouds.collect.Memoized;
import org.jclouds.concurrent.Futures;
import org.jclouds.domain.Location;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.blobstore.functions.BlobStoreListContainerOptionsToListContainerOptions;
import org.jclouds.openstack.swift.blobstore.functions.BlobToObject;
import org.jclouds.openstack.swift.blobstore.functions.ContainerToResourceList;
import org.jclouds.openstack.swift.blobstore.functions.ContainerToResourceMetadata;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlob;
import org.jclouds.openstack.swift.blobstore.functions.ObjectToBlobMetadata;
import org.jclouds.openstack.swift.domain.ContainerMetadata;
import org.jclouds.openstack.swift.domain.MutableObjectInfoWithMetadata;
import org.jclouds.openstack.swift.domain.ObjectInfo;
import org.jclouds.openstack.swift.domain.SwiftObject;
import org.jclouds.openstack.swift.options.ListContainerOptions;

@Singleton
public class SwiftAsyncBlobStore
extends BaseAsyncBlobStore {
    private final CommonSwiftClient sync;
    private final CommonSwiftAsyncClient async;
    private final ContainerToResourceMetadata container2ResourceMd;
    private final BlobStoreListContainerOptionsToListContainerOptions container2ContainerListOptions;
    private final ContainerToResourceList container2ResourceList;
    private final ObjectToBlob object2Blob;
    private final BlobToObject blob2Object;
    private final ObjectToBlobMetadata object2BlobMd;
    private final BlobToHttpGetOptions blob2ObjectGetOptions;
    private final Provider<FetchBlobMetadata> fetchBlobMetadataProvider;

    @Inject
    protected SwiftAsyncBlobStore(BlobStoreContext context, BlobUtils blobUtils, @Named(value="jclouds.user-threads") ExecutorService service, Supplier<Location> defaultLocation, @Memoized Supplier<Set<? extends Location>> locations, CommonSwiftClient sync, CommonSwiftAsyncClient async, ContainerToResourceMetadata container2ResourceMd, BlobStoreListContainerOptionsToListContainerOptions container2ContainerListOptions, ContainerToResourceList container2ResourceList, ObjectToBlob object2Blob, BlobToObject blob2Object, ObjectToBlobMetadata object2BlobMd, BlobToHttpGetOptions blob2ObjectGetOptions, Provider<FetchBlobMetadata> fetchBlobMetadataProvider) {
        super(context, blobUtils, service, defaultLocation, locations);
        this.sync = sync;
        this.async = async;
        this.container2ResourceMd = container2ResourceMd;
        this.container2ContainerListOptions = container2ContainerListOptions;
        this.container2ResourceList = container2ResourceList;
        this.object2Blob = object2Blob;
        this.blob2Object = blob2Object;
        this.object2BlobMd = object2BlobMd;
        this.blob2ObjectGetOptions = blob2ObjectGetOptions;
        this.fetchBlobMetadataProvider = Preconditions.checkNotNull(fetchBlobMetadataProvider, "fetchBlobMetadataProvider");
    }

    @Override
    public ListenableFuture<PageSet<? extends StorageMetadata>> list() {
        return Futures.compose(this.async.listContainers(new ListContainerOptions[0]), new Function<Set<ContainerMetadata>, PageSet<? extends StorageMetadata>>(){

            @Override
            public PageSet<? extends StorageMetadata> apply(Set<ContainerMetadata> from) {
                return new PageSetImpl<StorageMetadata>(Iterables.transform(from, SwiftAsyncBlobStore.this.container2ResourceMd), null);
            }
        }, this.service);
    }

    @Override
    public ListenableFuture<Boolean> containerExists(String container) {
        return this.async.containerExists(container);
    }

    @Override
    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container) {
        return this.async.createContainer(container);
    }

    @Override
    public ListenableFuture<PageSet<? extends StorageMetadata>> list(String container, org.jclouds.blobstore.options.ListContainerOptions options) {
        ListContainerOptions httpOptions = this.container2ContainerListOptions.apply(options);
        ListenableFuture<PageSet<ObjectInfo>> returnVal = this.async.listObjects(container, httpOptions);
        ListenableFuture<PageSet<? extends StorageMetadata>> list = Futures.compose(returnVal, this.container2ResourceList, this.service);
        return options.isDetailed() ? Futures.compose(list, this.fetchBlobMetadataProvider.get().setContainerName(container), this.service) : list;
    }

    @Override
    public ListenableFuture<Boolean> blobExists(String container, String key) {
        return this.async.objectExists(container, key);
    }

    @Override
    public ListenableFuture<BlobMetadata> blobMetadata(String container, String key) {
        return Futures.compose(this.async.getObjectInfo(container, key), new Function<MutableObjectInfoWithMetadata, BlobMetadata>(){

            @Override
            public BlobMetadata apply(MutableObjectInfoWithMetadata from) {
                return SwiftAsyncBlobStore.this.object2BlobMd.apply(from);
            }
        }, this.service);
    }

    @Override
    public ListenableFuture<Blob> getBlob(String container, String key, GetOptions options) {
        org.jclouds.http.options.GetOptions httpOptions = this.blob2ObjectGetOptions.apply(options);
        ListenableFuture<SwiftObject> returnVal = this.async.getObject(container, key, httpOptions);
        return Futures.compose(returnVal, this.object2Blob, this.service);
    }

    @Override
    public ListenableFuture<String> putBlob(String container, Blob blob) {
        BlobStoreUtils.createParentIfNeededAsync(this, container, blob);
        return this.async.putObject(container, this.blob2Object.apply(blob));
    }

    @Override
    public ListenableFuture<Void> removeBlob(String container, String key) {
        return this.async.removeObject(container, key);
    }

    @Override
    protected boolean deleteAndVerifyContainerGone(String container) {
        this.sync.deleteContainerIfEmpty(container);
        return !this.sync.containerExists(container);
    }

    @Override
    public ListenableFuture<String> putBlob(String container, Blob blob, PutOptions options) {
        return this.putBlob(container, blob);
    }

    @Override
    public ListenableFuture<Boolean> createContainerInLocation(Location location, String container, CreateContainerOptions options) {
        if (options.isPublicRead()) {
            throw new UnsupportedOperationException("publicRead");
        }
        return this.createContainerInLocation(location, container);
    }
}

