/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.config;

import com.google.inject.AbstractModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import org.jclouds.blobstore.AsyncBlobStore;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.attr.ConsistencyModel;
import org.jclouds.blobstore.config.BlobStoreMapModule;
import org.jclouds.blobstore.internal.BlobStoreContextImpl;
import org.jclouds.location.config.JustProviderLocationModule;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.blobstore.SwiftAsyncBlobStore;
import org.jclouds.openstack.swift.blobstore.SwiftBlobRequestSigner;
import org.jclouds.openstack.swift.blobstore.SwiftBlobStore;

public class SwiftBlobStoreContextModule
extends AbstractModule {
    @Override
    protected void configure() {
        this.install(new BlobStoreMapModule());
        this.install(new JustProviderLocationModule());
        this.bind(ConsistencyModel.class).toInstance(ConsistencyModel.STRICT);
        this.bind(AsyncBlobStore.class).to(SwiftAsyncBlobStore.class).in(Scopes.SINGLETON);
        this.bind(BlobStore.class).to(SwiftBlobStore.class).in(Scopes.SINGLETON);
        this.bind(BlobStoreContext.class).to((TypeLiteral<BlobStoreContext>)new TypeLiteral<BlobStoreContextImpl<CommonSwiftClient, CommonSwiftAsyncClient>>(){}).in(Scopes.SINGLETON);
        this.bind(BlobRequestSigner.class).to(SwiftBlobRequestSigner.class);
    }
}

