/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.openstack.swift.blobstore.functions.ResourceToObjectInfo;
import org.jclouds.openstack.swift.domain.SwiftObject;

@Singleton
public class BlobToObject
implements Function<Blob, SwiftObject> {
    private final ResourceToObjectInfo blob2ObjectMd;
    private final SwiftObject.Factory objectProvider;

    @Inject
    BlobToObject(ResourceToObjectInfo blob2ObjectMd, SwiftObject.Factory objectProvider) {
        this.blob2ObjectMd = blob2ObjectMd;
        this.objectProvider = objectProvider;
    }

    @Override
    public SwiftObject apply(Blob from) {
        if (from == null) {
            return null;
        }
        SwiftObject object = this.objectProvider.create(this.blob2ObjectMd.apply(from.getMetadata()));
        object.setPayload(Preconditions.checkNotNull(from.getPayload(), "payload: " + from));
        object.setAllHeaders(from.getAllHeaders());
        return object;
    }
}

