/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.config;

import com.google.inject.Provides;
import java.net.URI;
import javax.inject.Singleton;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpRetryHandler;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.json.config.GsonModule;
import org.jclouds.openstack.OpenStackAuthAsyncClient;
import org.jclouds.openstack.config.OpenStackAuthenticationModule;
import org.jclouds.openstack.handlers.RetryOnRenew;
import org.jclouds.openstack.swift.CommonSwiftAsyncClient;
import org.jclouds.openstack.swift.CommonSwiftClient;
import org.jclouds.openstack.swift.Storage;
import org.jclouds.openstack.swift.config.SwiftObjectModule;
import org.jclouds.openstack.swift.handlers.ParseSwiftErrorFromHttpResponse;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;

@ConfiguresRestClient
@RequiresHttp
public class BaseSwiftRestClientModule<S extends CommonSwiftClient, A extends CommonSwiftAsyncClient>
extends RestClientModule<S, A> {
    private final OpenStackAuthenticationModule module;

    public BaseSwiftRestClientModule(Class<S> syncClientType, Class<A> asyncClientType) {
        this(new OpenStackAuthenticationModule(), syncClientType, asyncClientType);
    }

    public BaseSwiftRestClientModule(OpenStackAuthenticationModule module, Class<S> syncClientType, Class<A> asyncClientType) {
        super(syncClientType, asyncClientType);
        this.module = module;
    }

    @Override
    protected void configure() {
        this.install(this.module);
        this.install(new SwiftObjectModule());
        this.bind(GsonModule.DateAdapter.class).to(GsonModule.Iso8601DateAdapter.class);
        super.configure();
    }

    @Override
    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseSwiftErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseSwiftErrorFromHttpResponse.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseSwiftErrorFromHttpResponse.class);
    }

    @Override
    protected void bindRetryHandlers() {
        this.bind(HttpRetryHandler.class).annotatedWith(ClientError.class).to(RetryOnRenew.class);
    }

    @Provides
    @Singleton
    @Storage
    protected URI provideStorageUrl(OpenStackAuthAsyncClient.AuthenticationResponse response) {
        return response.getServices().get("X-Storage-Url");
    }
}

