/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.domain;

import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class ContainerMetadata
implements Comparable<ContainerMetadata> {
    private String name;
    private long count;
    private long bytes;
    @SerializedName(value="X-Container-Read")
    private String readACL;
    private Map<String, String> metadata = Maps.newLinkedHashMap();

    public ContainerMetadata() {
    }

    public ContainerMetadata(String name, long count, long bytes, String readACL, Map<String, String> metadata) {
        this.name = name;
        this.count = count;
        this.bytes = bytes;
        this.readACL = readACL;
        this.metadata = metadata;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getBytes() {
        return this.bytes;
    }

    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    public boolean isPublic() {
        if (this.readACL == null) {
            return false;
        }
        return this.readACL.equals(".r:*,.rlistings");
    }

    public void setReadACL(String readACL) {
        this.readACL = readACL;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.bytes ^ this.bytes >>> 32);
        result = 31 * result + (int)(this.count ^ this.count >>> 32);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerMetadata other = (ContainerMetadata)obj;
        if (this.bytes != other.bytes) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public int compareTo(ContainerMetadata o) {
        if (this.getName() == null) {
            return -1;
        }
        return this == o ? 0 : this.getName().compareTo(o.getName());
    }

    public String toString() {
        return "ContainerMetadata [name=" + this.name + ", count=" + this.count + ", bytes=" + this.bytes + ", isPublic=" + this.isPublic() + "]";
    }
}

