/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.swift.domain.AccountMetadata;

public class ParseAccountMetadataResponseFromHeaders
implements Function<HttpResponse, AccountMetadata> {
    @Override
    public AccountMetadata apply(HttpResponse from) {
        String bytesString = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Account-Bytes-Used"), "X-Account-Bytes-Used");
        String containersCountString = Preconditions.checkNotNull(from.getFirstHeaderOrNull("X-Account-Container-Count"), "X-Account-Container-Count");
        return new AccountMetadata(Long.parseLong(containersCountString), Long.parseLong(bytesString));
    }
}

