/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.swift.domain.ObjectInfo;
import org.jclouds.openstack.swift.domain.internal.ObjectInfoImpl;
import org.jclouds.openstack.swift.options.ListContainerOptions;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class ParseObjectInfoListFromJsonResponse
extends ParseJson<PageSet<ObjectInfo>>
implements InvocationContext<ParseObjectInfoListFromJsonResponse> {
    private final Provider<UriBuilder> uriBuilders;
    private GeneratedHttpRequest<?> request;
    private String container;

    @Inject
    public ParseObjectInfoListFromJsonResponse(Json json, Provider<UriBuilder> uriBuilders) {
        super(json, new TypeLiteral<PageSet<ObjectInfo>>(){});
        this.uriBuilders = uriBuilders;
    }

    @Override
    public PageSet<ObjectInfo> apply(InputStream stream) {
        Preconditions.checkState(this.request != null, "request should be initialized at this point");
        Preconditions.checkState(this.request.getArgs() != null, "request.getArgs() should be initialized at this point");
        Preconditions.checkArgument(this.request.getArgs().get(0) instanceof String, "arg[0] must be a container name");
        Preconditions.checkArgument(this.request.getArgs().get(1) instanceof ListContainerOptions[], "arg[1] must be an array of ListContainerOptions");
        ListContainerOptions[] optionsList = (ListContainerOptions[])this.request.getArgs().get(1);
        ListContainerOptions options = optionsList.length > 0 ? optionsList[0] : ListContainerOptions.NONE;
        Type listType = new TypeToken<SortedSet<ObjectInfoImpl>>(){}.getType();
        try {
            SortedSet list = (SortedSet)this.apply(stream, listType);
            TreeSet<ObjectInfo> returnVal = Sets.newTreeSet(Iterables.transform(list, new Function<ObjectInfoImpl, ObjectInfo>(){

                @Override
                public ObjectInfo apply(ObjectInfoImpl from) {
                    return from.toBuilder().container(ParseObjectInfoListFromJsonResponse.this.container).uri(((UriBuilder)ParseObjectInfoListFromJsonResponse.this.uriBuilders.get()).uri(ParseObjectInfoListFromJsonResponse.this.request.getEndpoint()).path(from.getName()).replaceQuery("").build(new Object[0])).build();
                }
            }));
            boolean truncated = options.getMaxResults() == returnVal.size();
            String marker = truncated ? ((ObjectInfo)returnVal.last()).getName() : null;
            return new PageSetImpl<ObjectInfo>(returnVal, marker);
        }
        catch (IOException e) {
            throw new RuntimeException("problem reading response from request: " + this.request, e);
        }
    }

    @Override
    public ParseObjectInfoListFromJsonResponse setContext(HttpRequest request) {
        Preconditions.checkArgument(request instanceof GeneratedHttpRequest, "note this handler requires a GeneratedHttpRequest");
        this.request = (GeneratedHttpRequest)request;
        return this.setContainer(((GeneratedHttpRequest)GeneratedHttpRequest.class.cast(request)).getArgs().get(0).toString());
    }

    private ParseObjectInfoListFromJsonResponse setContainer(String container) {
        this.container = container;
        return this;
    }
}

