/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.swift.handlers;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.http.HttpUtils;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.util.Strings2;

public class ParseSwiftErrorFromHttpResponse
implements HttpErrorHandler {
    @Resource
    protected Logger logger = Logger.NULL;
    public static final String PREFIX = "^/v[0-9][^/]*/[a-zA-Z]+_[^/]+/";
    public static final Pattern CONTAINER_PATH = Pattern.compile("^/v[0-9][^/]*/[a-zA-Z]+_[^/]+/([^/]+)$");
    public static final Pattern CONTAINER_KEY_PATH = Pattern.compile("^/v[0-9][^/]*/[a-zA-Z]+_[^/]+/([^/]+)/(.*)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        void var3_8;
        HttpResponseException httpResponseException = new HttpResponseException(command, response);
        try {
            String content = this.parseErrorFromContentOrNull(command, response);
            HttpResponseException httpResponseException2 = content != null ? new HttpResponseException(command, response, content) : httpResponseException;
            switch (response.getStatusCode()) {
                case 401: {
                    AuthorizationException authorizationException = new AuthorizationException(httpResponseException2.getMessage(), httpResponseException2);
                    break;
                }
                case 404: {
                    if (command.getCurrentRequest().getMethod().equals("DELETE")) break;
                    String path = command.getCurrentRequest().getEndpoint().getPath();
                    Matcher matcher = CONTAINER_PATH.matcher(path);
                    if (matcher.find()) {
                        ContainerNotFoundException containerNotFoundException = new ContainerNotFoundException(matcher.group(1), content);
                        break;
                    }
                    matcher = CONTAINER_KEY_PATH.matcher(path);
                    if (!matcher.find()) break;
                    KeyNotFoundException keyNotFoundException = new KeyNotFoundException(matcher.group(1), matcher.group(2), content);
                    break;
                }
            }
        }
        catch (Throwable throwable) {
            HttpUtils.releasePayload(response);
            command.setException(httpResponseException);
            throw throwable;
        }
        HttpUtils.releasePayload(response);
        command.setException((Exception)var3_8);
    }

    String parseErrorFromContentOrNull(HttpCommand command, HttpResponse response) {
        if (response.getPayload() != null) {
            try {
                return Strings2.toStringAndClose(response.getPayload().getInput());
            }
            catch (IOException e) {
                this.logger.warn(e, "exception reading error from response", response);
            }
        }
        return null;
    }
}

