/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.providers;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.jclouds.providers.ProviderMetadata;

public abstract class BaseProviderMetadata
implements ProviderMetadata {
    public int hashCode() {
        int prime = 31;
        int result = 1;
        URI console = this.getConsole();
        URI homepage = this.getHomepage();
        URI docs = this.getApiDocumentation();
        String id = this.getId();
        String name = this.getName();
        String identityName = this.getIdentityName();
        String credentialName = this.getCredentialName();
        String type = this.getType();
        Set<String> linkedServices = this.getLinkedServices();
        Set<String> iso3166Codes = this.getIso3166Codes();
        result = 31 * result + (console == null ? 0 : console.hashCode());
        result = 31 * result + (homepage == null ? 0 : homepage.hashCode());
        result = 31 * result + (docs == null ? 0 : docs.hashCode());
        result = 31 * result + (id == null ? 0 : id.hashCode());
        result = 31 * result + (name == null ? 0 : name.hashCode());
        result = 31 * result + (identityName == null ? 0 : identityName.hashCode());
        result = 31 * result + (credentialName == null ? 0 : credentialName.hashCode());
        result = 31 * result + (type == null ? 0 : type.hashCode());
        result = 31 * result + (linkedServices == null ? 0 : ((Object)linkedServices).hashCode());
        result = 31 * result + (iso3166Codes == null ? 0 : ((Object)iso3166Codes).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        URI tConsole = this.getConsole();
        URI tHomepage = this.getHomepage();
        URI tDocs = this.getApiDocumentation();
        String tId = this.getId();
        String tName = this.getName();
        String tIdentityName = this.getIdentityName();
        String tCredentialName = this.getCredentialName();
        String tType = this.getType();
        Set<String> tLinkedServices = this.getLinkedServices();
        Set<String> tIso3166Codes = this.getIso3166Codes();
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProviderMetadata other = (ProviderMetadata)obj;
        URI oConsole = other.getConsole();
        URI oHomepage = other.getHomepage();
        URI oDocs = other.getApiDocumentation();
        String oId = other.getId();
        String oName = other.getName();
        String oIdentityName = other.getIdentityName();
        String oCredentialName = other.getCredentialName();
        String oType = other.getType();
        Set<String> oLinkedServices = other.getLinkedServices();
        Set<String> oIso3166Codes = other.getIso3166Codes();
        if (tConsole == null ? oConsole != null : !tConsole.equals(oConsole)) {
            return false;
        }
        if (tDocs == null ? oDocs != null : !tDocs.equals(oDocs)) {
            return false;
        }
        if (tHomepage == null ? oHomepage != null : !tHomepage.equals(oHomepage)) {
            return false;
        }
        if (tId == null ? oId != null : !tId.equals(oId)) {
            return false;
        }
        if (tName == null ? oName != null : !tName.equals(oName)) {
            return false;
        }
        if (tIdentityName == null ? oIdentityName != null : !tIdentityName.equals(oIdentityName)) {
            return false;
        }
        if (tCredentialName == null ? oCredentialName != null : !tCredentialName.equals(oCredentialName)) {
            return false;
        }
        if (tType == null ? oType != null : !tType.equals(oType)) {
            return false;
        }
        if (tLinkedServices == null ? oLinkedServices != null : !((Object)tLinkedServices).equals(oLinkedServices)) {
            return false;
        }
        return !(tIso3166Codes == null ? oIso3166Codes != null : !((Object)tIso3166Codes).equals(oIso3166Codes));
    }

    public String toString() {
        return "[id=" + this.getId() + ", type=" + this.getType() + ", name=" + this.getName() + ", identityName=" + this.getIdentityName() + ", credentialName=" + this.getCredentialName() + ", homePage=" + this.getHomepage() + ", console=" + this.getConsole() + ", apiDocs=" + this.getApiDocumentation() + ", linkedServices=" + this.getLinkedServices() + ", iso3166Codes=" + this.getIso3166Codes() + "]";
    }

    @Override
    public Set<String> getLinkedServices() {
        return ImmutableSet.of(this.getId());
    }
}

