/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.providers;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.util.Preconditions2;

public class ProviderPredicates {
    public static Predicate<ProviderMetadata> all() {
        return Predicates.alwaysTrue();
    }

    public static Predicate<ProviderMetadata> id(final String id) {
        Preconditions2.checkNotEmpty(id, "id must be defined");
        return new Predicate<ProviderMetadata>(){

            @Override
            public boolean apply(ProviderMetadata providerMetadata) {
                return providerMetadata.getId().equals(id);
            }

            public String toString() {
                return "id(" + id + ")";
            }
        };
    }

    public static Predicate<ProviderMetadata> type(final String type) {
        Preconditions2.checkNotEmpty(type, "type must be defined");
        return new Predicate<ProviderMetadata>(){

            @Override
            public boolean apply(ProviderMetadata providerMetadata) {
                return providerMetadata.getType().equals(type);
            }

            public String toString() {
                return "type(" + type + ")";
            }
        };
    }

    public static Predicate<ProviderMetadata> boundedByIso3166Code(final String iso3166Code) {
        Preconditions.checkNotNull(iso3166Code, "iso3166Code must not be null");
        return new Predicate<ProviderMetadata>(){

            @Override
            public boolean apply(ProviderMetadata providerMetadata) {
                return ProviderPredicates.providerContainsIso3166Code(providerMetadata, iso3166Code);
            }

            public String toString() {
                return "boundedByIso3166Code(" + iso3166Code + ")";
            }
        };
    }

    public static Predicate<ProviderMetadata> intersectingIso3166Code(final ProviderMetadata refProviderMetadata) {
        Preconditions.checkNotNull(refProviderMetadata, "refProviderMetadata must not be null");
        return new Predicate<ProviderMetadata>(){

            @Override
            public boolean apply(ProviderMetadata providerMetadata) {
                for (String refIso3166Code : refProviderMetadata.getIso3166Codes()) {
                    if (!ProviderPredicates.providerContainsIso3166Code(providerMetadata, refIso3166Code) || refProviderMetadata.equals(providerMetadata)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "intersectingIso3166Code(" + refProviderMetadata + ")";
            }
        };
    }

    private static boolean providerContainsIso3166Code(ProviderMetadata providerMetadata, String iso3166Code) {
        for (String availCode : providerMetadata.getIso3166Codes()) {
            if (!(iso3166Code.indexOf(45) == -1 ? availCode.startsWith(iso3166Code + "-") : availCode.equals(iso3166Code))) continue;
            return true;
        }
        return false;
    }
}

