/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.providers;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.ProviderPredicates;

public class Providers {
    private static Iterable<ProviderMetadata> fromServiceLoader() {
        return ServiceLoader.load(ProviderMetadata.class);
    }

    public static Iterable<ProviderMetadata> all() {
        return Providers.fromServiceLoader();
    }

    public static ProviderMetadata withId(String id) throws NoSuchElementException {
        return Iterables.find(Providers.all(), ProviderPredicates.id(id));
    }

    public static Iterable<ProviderMetadata> allBlobStore() {
        return Iterables.filter(Providers.all(), ProviderPredicates.type("blobstore"));
    }

    public static Iterable<ProviderMetadata> allCompute() {
        return Iterables.filter(Providers.all(), ProviderPredicates.type("compute"));
    }

    public static Iterable<ProviderMetadata> allQueue() {
        return Iterables.filter(Providers.all(), ProviderPredicates.type("queue"));
    }

    public static Iterable<ProviderMetadata> allTable() {
        return Iterables.filter(Providers.all(), ProviderPredicates.type("table"));
    }

    public static Iterable<ProviderMetadata> allLoadBalancer() {
        return Iterables.filter(Providers.all(), ProviderPredicates.type("loadbalancer"));
    }

    public static Iterable<ProviderMetadata> ofType(String type) {
        return Iterables.filter(Providers.all(), ProviderPredicates.type(type));
    }

    public static Iterable<ProviderMetadata> boundedByIso3166Code(String iso3166Code) {
        return Iterables.filter(Providers.all(), ProviderPredicates.boundedByIso3166Code(iso3166Code));
    }

    public static Iterable<ProviderMetadata> boundedByIso3166Code(String iso3166Code, String type) {
        return Iterables.filter(Providers.all(), Predicates.and(ProviderPredicates.boundedByIso3166Code(iso3166Code), ProviderPredicates.type(type)));
    }

    public static Iterable<ProviderMetadata> collocatedWith(ProviderMetadata providerMetadata) {
        return Iterables.filter(Providers.all(), ProviderPredicates.intersectingIso3166Code(providerMetadata));
    }

    public static Iterable<ProviderMetadata> collocatedWith(ProviderMetadata providerMetadata, String type) {
        return Iterables.filter(Providers.all(), Predicates.and(ProviderPredicates.intersectingIso3166Code(providerMetadata), ProviderPredicates.type(type)));
    }
}

