/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ExecutionList;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Stage;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Types;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.MoreExecutors;
import org.jclouds.concurrent.SingleThreaded;
import org.jclouds.concurrent.config.ConfiguresExecutorService;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.http.RequiresHttp;
import org.jclouds.http.config.ConfiguresHttpCommandExecutorService;
import org.jclouds.http.config.JavaUrlHttpCommandExecutorServiceModule;
import org.jclouds.lifecycle.config.LifeCycleModule;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;
import org.jclouds.location.config.ProvideIso3166CodesByLocationIdViaProperties;
import org.jclouds.logging.config.LoggingModule;
import org.jclouds.logging.jdk.config.JDKLoggingModule;
import org.jclouds.rest.ConfiguresCredentialStore;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.ConfiguresRestContext;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.annotations.Api;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.BuildVersion;
import org.jclouds.rest.annotations.Credential;
import org.jclouds.rest.annotations.Identity;
import org.jclouds.rest.config.CredentialStoreModule;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rest.config.RestModule;
import org.jclouds.rest.internal.RestContextImpl;

public class RestContextBuilder<S, A> {
    protected Properties properties;
    protected List<Module> modules = new ArrayList<Module>(3);
    protected Class<A> asyncClientType;
    protected Class<S> syncClientType;

    @Inject
    public RestContextBuilder(Class<S> syncClientClass, Class<A> asyncClientClass, Properties properties) {
        this.asyncClientType = Preconditions.checkNotNull(asyncClientClass, "asyncClientType");
        this.syncClientType = Preconditions.checkNotNull(syncClientClass, "syncClientType");
        this.properties = Preconditions.checkNotNull(properties, "properties");
    }

    public RestContextBuilder<S, A> withModules(Iterable<Module> modules) {
        Iterables.addAll(this.modules, modules);
        return this;
    }

    public Injector buildInjector() {
        this.addContextModule(this.modules);
        this.addClientModuleIfNotPresent(this.modules);
        this.addLoggingModuleIfNotPresent(this.modules);
        this.addHttpModuleIfNeededAndNotPresent(this.modules);
        this.ifHttpConfigureRestOtherwiseGuiceClientFactory(this.modules);
        this.addExecutorServiceIfNotPresent(this.modules);
        this.addCredentialStoreIfNotPresent(this.modules);
        this.modules.add(new LifeCycleModule());
        this.modules.add(new BindPropertiesAndPrincipalContext(this.properties));
        Injector returnVal = Guice.createInjector(Stage.PRODUCTION, this.modules);
        returnVal.getInstance(ExecutionList.class).execute();
        return returnVal;
    }

    @VisibleForTesting
    protected void addLoggingModuleIfNotPresent(List<Module> modules) {
        if (!Iterables.any(modules, Predicates.instanceOf(LoggingModule.class))) {
            modules.add(new JDKLoggingModule());
        }
    }

    @VisibleForTesting
    protected void addHttpModuleIfNeededAndNotPresent(List<Module> modules) {
        if (this.defaultOrAtLeastOneModuleRequiresHttp(modules) && this.nothingConfiguresAnHttpService(modules)) {
            modules.add(new JavaUrlHttpCommandExecutorServiceModule());
        }
    }

    private boolean nothingConfiguresAnHttpService(List<Module> modules) {
        return !Iterables.any(modules, new Predicate<Module>(){

            @Override
            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ConfiguresHttpCommandExecutorService.class);
            }
        });
    }

    @VisibleForTesting
    protected void addContextModuleIfNotPresent(List<Module> modules) {
        if (!Iterables.any(modules, new Predicate<Module>(){

            @Override
            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ConfiguresRestContext.class);
            }
        })) {
            this.addContextModule(modules);
        }
    }

    @VisibleForTesting
    protected void addContextModule(List<Module> modules) {
        modules.add(new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(TypeLiteral.get(Types.newParameterizedType(RestContext.class, new Type[]{RestContextBuilder.this.syncClientType, RestContextBuilder.this.asyncClientType}))).to(TypeLiteral.get(Types.newParameterizedType(RestContextImpl.class, new Type[]{RestContextBuilder.this.syncClientType, RestContextBuilder.this.asyncClientType}))).in(Scopes.SINGLETON);
            }

            public String toString() {
                return String.format("configure rest context %s->%s", RestContextBuilder.this.syncClientType.getSimpleName(), RestContextBuilder.this.asyncClientType.getSimpleName());
            }
        });
    }

    @VisibleForTesting
    protected void ifHttpConfigureRestOtherwiseGuiceClientFactory(List<Module> modules) {
        if (this.defaultOrAtLeastOneModuleRequiresHttp(modules)) {
            modules.add(new RestModule());
        }
    }

    private boolean defaultOrAtLeastOneModuleRequiresHttp(List<Module> modules) {
        return this.atLeastOneModuleRequiresHttp(modules) || !this.restClientModulePresent(modules);
    }

    private boolean atLeastOneModuleRequiresHttp(List<Module> modules) {
        return Iterables.any(modules, new Predicate<Module>(){

            @Override
            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(RequiresHttp.class);
            }
        });
    }

    @VisibleForTesting
    protected void addClientModuleIfNotPresent(List<Module> modules) {
        if (!this.restClientModulePresent(modules)) {
            this.addClientModule(modules);
        }
    }

    private boolean restClientModulePresent(List<Module> modules) {
        return Iterables.any(modules, new Predicate<Module>(){

            @Override
            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ConfiguresRestClient.class);
            }
        });
    }

    protected void addClientModule(List<Module> modules) {
        modules.add(new RestClientModule<S, A>(this.syncClientType, this.asyncClientType));
    }

    @VisibleForTesting
    protected void addExecutorServiceIfNotPresent(List<Module> modules) {
        if (!Iterables.any(modules, new Predicate<Module>(){

            @Override
            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ConfiguresExecutorService.class);
            }
        })) {
            if (Iterables.any(modules, new Predicate<Module>(){

                @Override
                public boolean apply(Module input) {
                    return input.getClass().isAnnotationPresent(SingleThreaded.class);
                }
            })) {
                modules.add(new ExecutorServiceModule(MoreExecutors.sameThreadExecutor(), MoreExecutors.sameThreadExecutor()));
            } else {
                modules.add(new ExecutorServiceModule());
            }
        }
    }

    @VisibleForTesting
    protected void addCredentialStoreIfNotPresent(List<Module> modules) {
        if (!Iterables.any(modules, new Predicate<Module>(){

            @Override
            public boolean apply(Module input) {
                return input.getClass().isAnnotationPresent(ConfiguresCredentialStore.class);
            }
        })) {
            modules.add(new CredentialStoreModule());
        }
    }

    @VisibleForTesting
    public Properties getProperties() {
        return this.properties;
    }

    public <T extends RestContext<S, A>> T buildContext() {
        Injector injector = this.buildInjector();
        return (T)((RestContext)injector.getInstance(Key.get(Types.newParameterizedType(RestContext.class, new Type[]{this.syncClientType, this.asyncClientType}))));
    }

    static class BindPropertiesAndPrincipalContext
    extends AbstractModule {
        protected Properties properties;

        protected BindPropertiesAndPrincipalContext(Properties properties) {
            this.properties = Preconditions.checkNotNull(properties, "properties");
        }

        @Provides
        @Singleton
        @Named(value="CONSTANTS")
        protected Multimap<String, String> constants() {
            ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                if (entry.getValue() == null) continue;
                builder.put(entry.getKey().toString(), entry.getValue().toString());
            }
            return LinkedHashMultimap.create(builder.build());
        }

        @Provides
        @Singleton
        @Named(value="TIMEOUTS")
        protected Map<String, Long> timeouts() {
            ImmutableMap.Builder<String, Long> builder = ImmutableMap.builder();
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                String key = String.valueOf(entry.getKey());
                if (!key.startsWith("jclouds.timeouts.") || entry.getValue() == null) continue;
                try {
                    Long val = Long.valueOf(String.valueOf(entry.getValue()));
                    builder.put(key.replaceFirst("jclouds.timeouts.", ""), val);
                }
                catch (Throwable t) {}
            }
            return builder.build();
        }

        @Override
        protected void configure() {
            Properties toBind = new Properties();
            toBind.putAll((Map<?, ?>)Preconditions.checkNotNull(this.properties, "properties"));
            toBind.putAll((Map<?, ?>)System.getProperties());
            Names.bindProperties(this.binder(), toBind);
            this.bind(String.class).annotatedWith(Provider.class).toInstance(Preconditions.checkNotNull(toBind.getProperty("jclouds.provider"), "jclouds.provider"));
            this.bind(URI.class).annotatedWith(Provider.class).toInstance(URI.create(Preconditions.checkNotNull(toBind.getProperty("jclouds.endpoint"), "jclouds.endpoint")));
            this.bind(new TypeLiteral<Set<String>>(){}).annotatedWith(Iso3166.class).toInstance(ImmutableSet.copyOf(Iterables.filter(Splitter.on(',').split(Preconditions.checkNotNull(toBind.getProperty("jclouds.iso3166-codes"), "jclouds.iso3166-codes")), Predicates.not(Predicates.equalTo("")))));
            this.bind(new TypeLiteral<Map<String, Set<String>>>(){}).annotatedWith(Iso3166.class).toProvider(ProvideIso3166CodesByLocationIdViaProperties.class);
            if (toBind.containsKey("jclouds.api")) {
                this.bind(String.class).annotatedWith(Api.class).toInstance(toBind.getProperty("jclouds.api"));
            }
            if (toBind.containsKey("jclouds.api-version")) {
                this.bind(String.class).annotatedWith(ApiVersion.class).toInstance(toBind.getProperty("jclouds.api-version"));
            }
            if (toBind.containsKey("jclouds.build-version")) {
                this.bind(String.class).annotatedWith(BuildVersion.class).toInstance(toBind.getProperty("jclouds.build-version"));
            }
            if (toBind.containsKey("jclouds.identity")) {
                this.bind(String.class).annotatedWith(Identity.class).toInstance(Preconditions.checkNotNull(toBind.getProperty("jclouds.identity"), "jclouds.identity"));
            }
            if (toBind.containsKey("jclouds.credential")) {
                this.bind(String.class).annotatedWith(Credential.class).toInstance(toBind.getProperty("jclouds.credential"));
            }
        }
    }
}

