/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import com.google.inject.Module;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.jclouds.PropertiesBuilder;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.Providers;
import org.jclouds.rest.RestContext;
import org.jclouds.rest.RestContextBuilder;
import org.jclouds.rest.RestContextSpec;
import org.jclouds.util.ClassLoadingUtils;
import org.jclouds.util.Modules2;
import org.jclouds.util.Strings2;
import org.jclouds.util.Throwables2;

public class RestContextFactory {
    private static final Properties NO_PROPERTIES = new Properties();
    private final Properties properties;

    public static <S, A> RestContextSpec<S, A> contextSpec(String provider, String endpoint, String apiVersion, String buildVersion, String iso3166Codes, String identity, String credential, Class<S> sync, Class<A> async, Class<PropertiesBuilder> propertiesBuilderClass, Class<RestContextBuilder<S, A>> contextBuilderClass, Iterable<Module> modules) {
        return new RestContextSpec<S, A>(provider, endpoint, apiVersion, buildVersion, iso3166Codes, identity, credential, sync, async, propertiesBuilderClass, contextBuilderClass, modules);
    }

    public static <S, A> RestContextSpec<S, A> contextSpec(String provider, String endpoint, String apiVersion, String buildVersion, String iso3166Codes, String identity, String credential, Class<S> sync, Class<A> async) {
        return new RestContextSpec<S, A>(provider, endpoint, apiVersion, buildVersion, iso3166Codes, identity, credential, sync, async);
    }

    public static <S, A> RestContextSpec<S, A> contextSpec(String provider, String endpoint, String apiVersion, String buildVersion, String iso3166Codes, String identity, String credential, Class<S> sync, Class<A> async, Iterable<Module> modules) {
        return new RestContextSpec<S, A>(provider, endpoint, apiVersion, buildVersion, iso3166Codes, identity, credential, sync, async, PropertiesBuilder.class, RestContextBuilder.class, modules);
    }

    public RestContextFactory() {
        this("/rest.properties");
    }

    public RestContextFactory(String filename) {
        this(RestContextFactory.getPropertiesFromResource(filename));
    }

    public static Properties getPropertiesFromResource(String filename) {
        Properties properties = new Properties();
        try {
            properties.load(RestContextFactory.class.getResourceAsStream(filename));
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
        properties.putAll((Map<?, ?>)System.getProperties());
        return properties;
    }

    @Inject
    public RestContextFactory(Properties properties) {
        this.properties = properties;
    }

    public <S, A> RestContextBuilder<S, A> createContextBuilder(String provider, String identity, String credential) {
        return this.createContextBuilder(provider, identity, credential, ImmutableSet.of(), NO_PROPERTIES);
    }

    public <S, A> RestContextBuilder<S, A> createContextBuilder(String provider, Properties overrides) {
        return this.createContextBuilder(provider, null, null, ImmutableSet.of(), overrides);
    }

    public <S, A> RestContextBuilder<S, A> createContextBuilder(String provider, Iterable<Module> modules) {
        return this.createContextBuilder(provider, null, null, modules, NO_PROPERTIES);
    }

    public <S, A> RestContextBuilder<S, A> createContextBuilder(String provider, Iterable<? extends Module> wiring, Properties overrides) {
        return this.createContextBuilder(provider, null, null, wiring, overrides);
    }

    public <S, A> RestContextBuilder<S, A> createContextBuilder(String provider, @Nullable String identity, @Nullable String credential, Properties properties) {
        return this.createContextBuilder(provider, identity, credential, Collections.EMPTY_LIST, properties);
    }

    public <S, A> RestContextBuilder<S, A> createContextBuilder(String provider, @Nullable String identity, @Nullable String credential, Iterable<? extends Module> wiring) {
        return this.createContextBuilder(provider, identity, credential, wiring, NO_PROPERTIES);
    }

    public <S, A> RestContextBuilder<S, A> createContextBuilder(String providerName, @Nullable String identity, @Nullable String credential, Iterable<? extends Module> wiring, Properties _overrides) {
        Preconditions.checkNotNull(wiring, "wiring");
        RestContextSpec<S, A> contextSpec = this.createContextSpec(providerName, identity, credential, wiring, _overrides);
        return RestContextFactory.createContextBuilder(contextSpec, _overrides);
    }

    public static Properties toProperties(RestContextSpec<?, ?> contextSpec) {
        Preconditions.checkNotNull(contextSpec, "contextSpec");
        Properties props = new Properties();
        props.setProperty(contextSpec.provider + ".endpoint", contextSpec.endpoint);
        props.setProperty(contextSpec.provider + ".api-version", contextSpec.apiVersion);
        props.setProperty(contextSpec.provider + ".build-version", contextSpec.buildVersion);
        props.setProperty(contextSpec.provider + "." + "iso3166-codes", contextSpec.iso3166Codes);
        props.setProperty(contextSpec.provider + ".identity", contextSpec.identity);
        if (contextSpec.credential != null) {
            props.setProperty(contextSpec.provider + ".credential", contextSpec.credential);
        }
        if (contextSpec.sync != null) {
            props.setProperty(contextSpec.provider + ".sync", contextSpec.sync.getName());
            props.setProperty(contextSpec.provider + ".async", Preconditions.checkNotNull(contextSpec.async, "contextSpec.async").getName());
        } else {
            props.setProperty(contextSpec.provider + ".contextbuilder", Preconditions.checkNotNull(contextSpec.contextBuilderClass, "contextSpec.contextBuilderClass").getName());
            props.setProperty(contextSpec.provider + ".propertiesbuilder", Preconditions.checkNotNull(contextSpec.propertiesBuilderClass, "contextSpec.propertiesBuilderClass").getName());
        }
        if (Iterables.size(contextSpec.modules) > 0) {
            props.setProperty(contextSpec.provider + ".modules", Joiner.on(',').join(Iterables.transform(contextSpec.modules, new Function<Module, String>(){

                @Override
                public String apply(Module from) {
                    return from.getClass().getName();
                }
            })));
        }
        return props;
    }

    public <S, A> RestContextSpec<S, A> createContextSpec(String providerName, String identity, String credential, Properties _overrides) {
        return this.createContextSpec(providerName, identity, credential, Collections.EMPTY_LIST, _overrides);
    }

    public <S, A> RestContextSpec<S, A> createContextSpec(String providerName, String identity, String credential, Iterable<? extends Module> wiring, Properties _overrides) {
        Class<?> async;
        Class<?> sync;
        Class<PropertiesBuilder> propertiesBuilderClass;
        Class contextBuilderClass;
        Preconditions.checkNotNull(providerName, "providerName");
        Preconditions.checkNotNull(_overrides, "overrides");
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.properties);
        props.putAll((Map<?, ?>)_overrides);
        String endpoint = props.getProperty(providerName + "." + "endpoint", null);
        String iso3166Codes = props.getProperty(providerName + "." + "iso3166-codes", null);
        String apiVersion = props.getProperty(providerName + ".api-version", null);
        String buildVersion = props.getProperty(providerName + ".build-version", null);
        identity = props.getProperty(providerName + ".identity", props.getProperty("jclouds.identity", identity));
        credential = RestContextFactory.loadCredentialOrDefault(props, providerName + ".credential", RestContextFactory.loadCredentialOrDefault(props, "jclouds.credential", credential));
        String syncClassName = props.getProperty(providerName + ".sync", null);
        String asyncClassName = props.getProperty(providerName + ".async", null);
        Iterable<Module> modules = Iterables.concat(Modules2.modulesForProviderInProperties(providerName, props), wiring);
        try {
            contextBuilderClass = Providers.resolveContextBuilderClass(providerName, props);
            propertiesBuilderClass = Providers.resolvePropertiesBuilderClass(providerName, props);
            sync = syncClassName != null ? ClassLoadingUtils.loadClass(this.getClass(), syncClassName) : null;
            async = asyncClassName != null ? ClassLoadingUtils.loadClass(this.getClass(), asyncClassName) : null;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("The specified provider \"%s\" is either not configured or supported. Currently configured providers are:%n  %s%nCheck this list, as the provider name may have changed. If you are sure that provider name is correct, check that your project has a dependency on org.jclouds.provider/%s, or on org.jclouds/jclouds-all.", providerName, Providers.getSupportedProviders(), providerName), e);
        }
        catch (Exception e) {
            Throwables.propagate(e);
            assert (false) : "exception should have propogated " + e;
            return null;
        }
        RestContextSpec contextSpec = new RestContextSpec(providerName, endpoint, apiVersion, buildVersion, iso3166Codes, identity, credential, sync, async, propertiesBuilderClass, contextBuilderClass, modules);
        return contextSpec;
    }

    static String loadCredentialOrDefault(Properties properties, String property, String credential) {
        if (properties.containsKey(property)) {
            return properties.getProperty(property);
        }
        if (properties.containsKey(property + ".resource")) {
            try {
                return Strings2.toStringAndClose(RestContextFactory.class.getResourceAsStream(properties.getProperty(property + ".resource")));
            }
            catch (IOException e) {
                throw new RuntimeException("error reading resource: " + properties.getProperty(property + ".resource"));
            }
        }
        if (properties.containsKey(property + ".file")) {
            try {
                return Files.toString(new File(properties.getProperty(property + ".file")), Charsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException("error reading file: " + properties.getProperty(property + ".file"));
            }
        }
        return credential;
    }

    public static <S, A> RestContextBuilder<S, A> createContextBuilder(RestContextSpec<S, A> contextSpec) {
        return RestContextFactory.createContextBuilder(contextSpec, NO_PROPERTIES);
    }

    public static <S, A> RestContextBuilder<S, A> createContextBuilder(RestContextSpec<S, A> contextSpec, Properties overrides) {
        return RestContextFactory.createContextBuilder(contextSpec, Collections.EMPTY_LIST, overrides);
    }

    public static <S, A> RestContextBuilder<S, A> createContextBuilder(RestContextSpec<S, A> contextSpec, Iterable<Module> modules) {
        return RestContextFactory.createContextBuilder(contextSpec, modules, NO_PROPERTIES);
    }

    public static <S, A> RestContextBuilder<S, A> createContextBuilder(RestContextSpec<S, A> contextSpec, Iterable<Module> modules, Properties overrides) {
        try {
            PropertiesBuilder builder = contextSpec.propertiesBuilderClass.getConstructor(Properties.class).newInstance(overrides);
            builder.provider(contextSpec.provider);
            if (contextSpec.apiVersion != null) {
                builder.apiVersion(contextSpec.apiVersion);
            }
            if (contextSpec.buildVersion != null) {
                builder.buildVersion(contextSpec.buildVersion);
            }
            if (contextSpec.iso3166Codes != null) {
                builder.iso3166Codes(Splitter.on('.').split(contextSpec.iso3166Codes));
            }
            if (contextSpec.identity != null) {
                builder.credentials(contextSpec.identity, contextSpec.credential);
            }
            if (contextSpec.endpoint != null) {
                builder.endpoint(contextSpec.endpoint);
            }
            RestContextBuilder contextBuilder = Providers.initContextBuilder(contextSpec.contextBuilderClass, contextSpec.sync, contextSpec.async, builder.build());
            contextBuilder.withModules(Iterables.concat(modules, contextSpec.modules));
            return contextBuilder;
        }
        catch (Exception e) {
            return (RestContextBuilder)Throwables2.propagateAuthorizationOrOriginalException(e);
        }
    }

    public <S, A> RestContext<S, A> createContext(String provider, String identity, String credential) {
        RestContextBuilder<S, A> builder = this.createContextBuilder(provider, identity, credential);
        return RestContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public static <S, A> RestContext<S, A> buildContextUnwrappingExceptions(RestContextBuilder<S, A> builder) {
        try {
            return builder.buildContext();
        }
        catch (Exception e) {
            return (RestContext)Throwables2.propagateAuthorizationOrOriginalException(e);
        }
    }

    public <S, A> RestContext<S, A> createContext(String provider, Properties overrides) {
        RestContextBuilder<S, A> builder = this.createContextBuilder(provider, overrides);
        return RestContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public <S, A> RestContext<S, A> createContext(String provider, Iterable<? extends Module> wiring, Properties overrides) {
        RestContextBuilder<S, A> builder = this.createContextBuilder(provider, wiring, overrides);
        return RestContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public <S, A> RestContext<S, A> createContext(String provider, @Nullable String identity, @Nullable String credential, Properties properties) {
        RestContextBuilder<S, A> builder = this.createContextBuilder(provider, identity, credential, properties);
        return RestContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public <S, A> RestContext<S, A> createContext(String provider, @Nullable String identity, @Nullable String credential, Iterable<? extends Module> wiring) {
        RestContextBuilder<S, A> builder = this.createContextBuilder(provider, identity, credential, wiring);
        return RestContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public <S, A> RestContext<S, A> createContext(String provider, @Nullable String identity, @Nullable String credential, Iterable<? extends Module> wiring, Properties overrides) {
        RestContextBuilder<S, A> builder = this.createContextBuilder(provider, identity, credential, wiring, overrides);
        return RestContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public static <S, A> RestContext<S, A> createContext(RestContextSpec<S, A> contextSpec) {
        RestContextBuilder<S, A> builder = RestContextFactory.createContextBuilder(contextSpec);
        return RestContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public static <S, A> RestContext<S, A> createContext(RestContextSpec<S, A> contextSpec, Properties overrides) {
        RestContextBuilder<S, A> builder = RestContextFactory.createContextBuilder(contextSpec, overrides);
        return RestContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public static <S, A> RestContext<S, A> createContext(RestContextSpec<S, A> contextSpec, Iterable<Module> modules) {
        RestContextBuilder<S, A> builder = RestContextFactory.createContextBuilder(contextSpec, modules);
        return RestContextFactory.buildContextUnwrappingExceptions(builder);
    }

    public static <S, A> RestContext<S, A> createContext(RestContextSpec<S, A> contextSpec, Iterable<Module> modules, Properties overrides) {
        RestContextBuilder<S, A> builder = RestContextFactory.createContextBuilder(contextSpec, modules, overrides);
        return RestContextFactory.buildContextUnwrappingExceptions(builder);
    }
}

