/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.assistedinject.Assisted;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.Binder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class BindToJsonPayloadWrappedWith
implements Binder {
    private final BindToJsonPayload jsonBinder;
    private final String envelope;

    @Inject
    BindToJsonPayloadWrappedWith(BindToJsonPayload jsonBinder, @Assisted String envelope) {
        this.jsonBinder = Preconditions.checkNotNull(jsonBinder, "jsonBinder");
        this.envelope = Preconditions.checkNotNull(envelope, "envelope");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        return this.jsonBinder.bindToRequest(request, ImmutableMap.of(this.envelope, Preconditions.checkNotNull(payload, "payload")));
    }

    public static interface Factory {
        public BindToJsonPayloadWrappedWith create(String var1);
    }
}

