/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.inject.Binder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.jclouds.rest.config.AsyncClientProvider;
import org.jclouds.rest.config.ClientProvider;

public class BinderUtils {
    public static <K, V> void bindClient(Binder binder, Class<K> syncClientType, Class<V> asyncClientType, Map<Class<?>, Class<?>> delegates) {
        ClientProvider<K, V> asyncProvider = new ClientProvider<K, V>(syncClientType, asyncClientType, delegates);
        binder.requestInjection(asyncProvider);
        binder.bind(syncClientType).toProvider(asyncProvider);
    }

    public static <T> void bindAsyncClient(Binder binder, Class<T> asyncClientType) {
        AsyncClientProvider<T> asyncProvider = new AsyncClientProvider<T>(asyncClientType);
        binder.requestInjection(asyncProvider);
        binder.bind(asyncClientType).toProvider(asyncProvider);
    }

    public static <T> T newNullProxy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        });
    }
}

