/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.config;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.jclouds.concurrent.internal.SyncProxy;
import org.jclouds.internal.ClassMethodArgs;

public class CreateClientForCaller
extends CacheLoader<ClassMethodArgs, Object> {
    @Inject
    Injector injector;
    private final LoadingCache<ClassMethodArgs, Object> asyncMap;
    private final Provider<LoadingCache<ClassMethodArgs, Object>> delegateMap;
    Map<Class<?>, Class<?>> sync2Async;

    @Inject
    CreateClientForCaller(@Named(value="async") LoadingCache<ClassMethodArgs, Object> asyncMap, @Named(value="sync") Provider<LoadingCache<ClassMethodArgs, Object>> delegateMap) {
        this.asyncMap = asyncMap;
        this.delegateMap = delegateMap;
    }

    @Override
    public Object load(ClassMethodArgs from) throws ExecutionException {
        Class<?> syncClass = from.getMethod().getReturnType();
        Class<?> asyncClass = this.sync2Async.get(syncClass);
        Preconditions.checkState(asyncClass != null, "configuration error, sync class " + syncClass + " not mapped to an async class");
        Object asyncClient = this.asyncMap.get(from);
        Preconditions.checkState(asyncClient != null, "configuration error, sync client for " + from + " not found");
        try {
            return SyncProxy.proxy(syncClass, asyncClient, this.delegateMap.get(), this.sync2Async, this.injector.getInstance(Key.get(new TypeLiteral<Map<String, Long>>(){}, (Annotation)Names.named("TIMEOUTS"))));
        }
        catch (Exception e) {
            Throwables.propagate(e);
            assert (false) : "should have propagated";
            return null;
        }
    }
}

