/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Named;
import javax.inject.Qualifier;
import javax.inject.Singleton;
import org.jclouds.concurrent.ExceptionParsingListenableFuture;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.TransformingHttpCommand;
import org.jclouds.internal.ClassMethodArgs;
import org.jclouds.logging.Logger;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.annotations.Delegate;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.jclouds.util.Throwables2;

@Singleton
public class AsyncRestClientProxy<T>
implements InvocationHandler {
    private final Injector injector;
    private final RestAnnotationProcessor<T> annotationProcessor;
    private final Class<T> declaring;
    private final Factory commandFactory;
    @Inject(optional=true)
    @Named(value="jclouds.request-timeout")
    protected long requestTimeoutMilliseconds = 30000L;
    @Resource
    protected Logger logger = Logger.NULL;
    private final LoadingCache<ClassMethodArgs, Object> delegateMap;
    private static final Predicate<Annotation> isQualifierPresent = new Predicate<Annotation>(){

        @Override
        public boolean apply(Annotation input) {
            return input.annotationType().isAnnotationPresent(Qualifier.class);
        }
    };

    @Inject
    public AsyncRestClientProxy(Injector injector, Factory factory, RestAnnotationProcessor<T> util, TypeLiteral<T> typeLiteral, @Named(value="async") LoadingCache<ClassMethodArgs, Object> delegateMap) {
        this.injector = injector;
        this.annotationProcessor = util;
        this.declaring = typeLiteral.getRawType();
        this.commandFactory = factory;
        this.delegateMap = delegateMap;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("equals")) {
            return this.equals(o);
        }
        if (method.getName().equals("toString")) {
            return this.toString();
        }
        if (method.getName().equals("hashCode")) {
            return this.hashCode();
        }
        if (method.isAnnotationPresent(Provides.class)) {
            try {
                try {
                    Annotation qualifier = Iterables.find(ImmutableList.copyOf(method.getAnnotations()), isQualifierPresent);
                    return this.injector.getInstance(Key.get(method.getGenericReturnType(), qualifier));
                }
                catch (NoSuchElementException e) {
                    return this.injector.getInstance(Key.get(method.getGenericReturnType()));
                }
            }
            catch (ProvisionException e) {
                AuthorizationException aex = Throwables2.getFirstThrowableOfType(e, AuthorizationException.class);
                if (aex != null) {
                    throw aex;
                }
                throw e;
            }
        }
        if (method.isAnnotationPresent(Delegate.class)) {
            return this.delegateMap.get(new ClassMethodArgs(method.getReturnType(), method, args));
        }
        if (this.annotationProcessor.getDelegateOrNull(method) != null && ListenableFuture.class.isAssignableFrom(method.getReturnType())) {
            return this.createListenableFuture(method, args);
        }
        throw new RuntimeException("method is intended solely to set constants: " + method);
    }

    private ListenableFuture<?> createListenableFuture(Method method, Object[] args) throws ExecutionException {
        ListenableFuture<?> result;
        method = this.annotationProcessor.getDelegateOrNull(method);
        this.logger.trace("Converting %s.%s", this.declaring.getSimpleName(), method.getName());
        Function<Exception, ?> exceptionParser = this.annotationProcessor.createExceptionParserOrThrowResourceNotFoundOn404IfNoAnnotation(method);
        if (exceptionParser instanceof InvocationContext) {
            ((InvocationContext)((Object)exceptionParser)).setContext(null);
        }
        try {
            GeneratedHttpRequest<T> request = this.annotationProcessor.createRequest(method, args);
            if (exceptionParser instanceof InvocationContext) {
                ((InvocationContext)((Object)exceptionParser)).setContext(request);
            }
            this.logger.trace("Converted %s.%s to %s", this.declaring.getSimpleName(), method.getName(), request.getRequestLine());
            Function<HttpResponse, ?> transformer = this.annotationProcessor.createResponseParser(method, request);
            this.logger.trace("Response from %s.%s is parsed by %s", this.declaring.getSimpleName(), method.getName(), transformer.getClass().getSimpleName());
            this.logger.debug("Invoking %s.%s", this.declaring.getSimpleName(), method.getName());
            result = this.commandFactory.create(request, transformer).execute();
        }
        catch (RuntimeException e2) {
            AuthorizationException e2;
            AuthorizationException aex = Throwables2.getFirstThrowableOfType(e2, AuthorizationException.class);
            if (aex != null) {
                e2 = aex;
            }
            if (exceptionParser != null) {
                try {
                    return Futures.immediateFuture(exceptionParser.apply(e2));
                }
                catch (Exception ex) {
                    return Futures.immediateFailedFuture(ex);
                }
            }
            return Futures.immediateFailedFuture(e2);
        }
        if (exceptionParser != null) {
            this.logger.trace("Exceptions from %s.%s are parsed by %s", this.declaring.getSimpleName(), method.getName(), exceptionParser.getClass().getSimpleName());
            result = new ExceptionParsingListenableFuture(result, exceptionParser);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AsyncRestClientProxy)) {
            return false;
        }
        AsyncRestClientProxy other = (AsyncRestClientProxy)obj;
        if (other == this) {
            return true;
        }
        if (other.declaring != this.declaring) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.declaring.hashCode();
    }

    public String toString() {
        return "Client Proxy for :" + this.declaring.getName();
    }

    public static interface Factory {
        public TransformingHttpCommand<?> create(HttpRequest var1, Function<HttpResponse, ?> var2);
    }
}

