/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.io.Payload;
import org.jclouds.javax.annotation.Nullable;

public class GeneratedHttpRequest<T>
extends HttpRequest {
    private final Class<T> declaring;
    private final Method javaMethod;
    private final List<Object> args;

    public static Builder<?> builder() {
        return new Builder();
    }

    public static <T> Builder<T> requestBuilder() {
        return GeneratedHttpRequest.builder();
    }

    GeneratedHttpRequest(String method, URI endpoint, char[] skips, List<HttpRequestFilter> requestFilters, @Nullable Payload payload, Multimap<String, String> headers, Class<T> declaring, Method javaMethod, Iterable<Object> args) {
        super(method, endpoint, skips, requestFilters, payload, headers);
        this.declaring = Preconditions.checkNotNull(declaring, "declaring");
        this.javaMethod = Preconditions.checkNotNull(javaMethod, "javaMethod");
        this.args = Lists.newArrayList(Preconditions.checkNotNull(args, "args"));
    }

    public Class<T> getDeclaring() {
        return this.declaring;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public List<Object> getArgs() {
        return this.args;
    }

    @Override
    public Builder<T> toBuilder() {
        return Builder.from(this);
    }

    public static class Builder<T>
    extends HttpRequest.Builder {
        protected Class<T> declaring;
        protected Method javaMethod;
        protected List<Object> args;

        public Builder<T> declaring(Class<T> declaring) {
            this.declaring = Preconditions.checkNotNull(declaring, "declaring");
            return this;
        }

        public Builder<T> javaMethod(Method javaMethod) {
            this.javaMethod = Preconditions.checkNotNull(javaMethod, "javaMethod");
            return this;
        }

        public Builder<T> args(Object[] args) {
            return this.args(args == null ? ImmutableList.of() : Lists.newArrayList(args));
        }

        public Builder<T> args(List<Object> args) {
            this.args = Preconditions.checkNotNull(args, "args");
            return this;
        }

        @Override
        public Builder<T> filters(List<HttpRequestFilter> requestFilters) {
            return (Builder)super.filters(requestFilters);
        }

        @Override
        public Builder<T> method(String method) {
            return (Builder)super.method(method);
        }

        @Override
        public Builder<T> endpoint(URI endpoint) {
            return (Builder)super.endpoint(endpoint);
        }

        @Override
        public Builder<T> skips(char[] skips) {
            return (Builder)super.skips(skips);
        }

        @Override
        public Builder<T> payload(Payload payload) {
            return (Builder)super.payload(payload);
        }

        @Override
        public Builder<T> headers(Multimap<String, String> headers) {
            return (Builder)super.headers((Multimap)headers);
        }

        @Override
        public GeneratedHttpRequest<T> build() {
            return new GeneratedHttpRequest<T>(this.method, this.endpoint, this.skips, this.requestFilters, this.payload, this.headers, this.declaring, this.javaMethod, this.args);
        }

        public static Builder<?> from(HttpRequest input) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().method(input.getMethod())).endpoint(input.getEndpoint())).skips(input.getSkips())).filters((List)input.getFilters())).payload(input.getPayload())).headers((Multimap)input.getHeaders());
        }

        public static <Y> Builder<Y> fromRequest(HttpRequest input) {
            return Builder.from(input);
        }

        public static <Y> Builder<Y> from(GeneratedHttpRequest<Y> input) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().method(input.getMethod())).endpoint(input.getEndpoint())).skips(input.getSkips())).filters((List)input.getFilters())).payload(input.getPayload())).headers((Multimap)input.getHeaders())).declaring(input.getDeclaring()).javaMethod(input.getJavaMethod()).args(input.getArgs());
        }
    }
}

