/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Types;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Provider;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.functions.OnlyElementOrNull;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.functions.ParseFirstJsonValueNamed;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ParseURIFromListOrLocationHeaderIf20x;
import org.jclouds.http.functions.ParseXMLWithJAXB;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.http.functions.ReturnInputStream;
import org.jclouds.http.functions.ReturnStringIf2xx;
import org.jclouds.http.functions.ReturnTrueIf2xx;
import org.jclouds.http.functions.UnwrapOnlyJsonValue;
import org.jclouds.http.options.HttpRequestOptions;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.internal.ClassMethodArgs;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;
import org.jclouds.io.payloads.MultipartForm;
import org.jclouds.io.payloads.Part;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.internal.GsonWrapper;
import org.jclouds.logging.Logger;
import org.jclouds.rest.Binder;
import org.jclouds.rest.InputParamValidator;
import org.jclouds.rest.InvocationContext;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.BuildVersion;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.JAXBResponseParser;
import org.jclouds.rest.annotations.MatrixParams;
import org.jclouds.rest.annotations.OnlyElement;
import org.jclouds.rest.annotations.OverrideRequestFilters;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.PartParam;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.PayloadParams;
import org.jclouds.rest.annotations.QueryParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.rest.binders.BindMapToStringPayload;
import org.jclouds.rest.binders.BindToJsonPayloadWrappedWith;
import org.jclouds.rest.functions.MapHttp4xxCodesToExceptions;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Maps2;
import org.jclouds.util.Strings2;

public class RestAnnotationProcessor<T> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Class<T> declaring;
    static final LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> methodToIndexOfParamToBinderParamAnnotation = RestAnnotationProcessor.createMethodToIndexOfParamToAnnotation(BinderParam.class);
    static final LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> methodToIndexOfParamToWrapWithAnnotation = RestAnnotationProcessor.createMethodToIndexOfParamToAnnotation(WrapWith.class);
    static final LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> methodToIndexOfParamToHeaderParamAnnotations = RestAnnotationProcessor.createMethodToIndexOfParamToAnnotation(HeaderParam.class);
    static final LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> methodToIndexOfParamToEndpointAnnotations = RestAnnotationProcessor.createMethodToIndexOfParamToAnnotation(Endpoint.class);
    static final LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> methodToIndexOfParamToEndpointParamAnnotations = RestAnnotationProcessor.createMethodToIndexOfParamToAnnotation(EndpointParam.class);
    static final LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> methodToIndexOfParamToMatrixParamAnnotations = RestAnnotationProcessor.createMethodToIndexOfParamToAnnotation(MatrixParam.class);
    static final LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> methodToIndexOfParamToFormParamAnnotations = RestAnnotationProcessor.createMethodToIndexOfParamToAnnotation(FormParam.class);
    static final LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> methodToIndexOfParamToQueryParamAnnotations = RestAnnotationProcessor.createMethodToIndexOfParamToAnnotation(QueryParam.class);
    static final LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> methodToIndexOfParamToPathParamAnnotations = RestAnnotationProcessor.createMethodToIndexOfParamToAnnotation(PathParam.class);
    static final LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> methodToIndexOfParamToPostParamAnnotations = RestAnnotationProcessor.createMethodToIndexOfParamToAnnotation(PayloadParam.class);
    static final LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> methodToIndexOfParamToPartParamAnnotations = RestAnnotationProcessor.createMethodToIndexOfParamToAnnotation(PartParam.class);
    static final LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> methodToIndexOfParamToParamParserAnnotations = RestAnnotationProcessor.createMethodToIndexOfParamToAnnotation(ParamParser.class);
    static final Map<MethodKey, Method> delegationMap = Maps.newHashMap();
    private static final Class<? extends HttpRequestOptions[]> optionsVarArgsClass = new HttpRequestOptions[0].getClass();
    private static final Function<? super Map.Entry<String, String>, ? extends Part> ENTRY_TO_PART = new Function<Map.Entry<String, String>, Part>(){

        @Override
        public Part apply(Map.Entry<String, String> from) {
            return Part.create(from.getKey(), from.getValue());
        }
    };
    static final LoadingCache<Method, Set<Integer>> methodToIndexesOfOptions = CacheBuilder.newBuilder().build(new CacheLoader<Method, Set<Integer>>(){

        @Override
        public Set<Integer> load(Method method) {
            ImmutableSet.Builder toReturn = ImmutableSet.builder();
            for (int index = 0; index < method.getParameterTypes().length; ++index) {
                Class<?> type = method.getParameterTypes()[index];
                if (!HttpRequestOptions.class.isAssignableFrom(type) && !optionsVarArgsClass.isAssignableFrom(type)) continue;
                toReturn.add((Object)index);
            }
            return toReturn.build();
        }
    });
    private final ParseSax.Factory parserFactory;
    private final HttpUtils utils;
    private final Provider<UriBuilder> uriBuilderProvider;
    private final LoadingCache<Class<?>, Boolean> seedAnnotationCache;
    private final String apiVersion;
    private final String buildVersion;
    private char[] skips;
    @Inject
    private InputParamValidator inputParamValidator;
    final Injector injector;
    private ClassMethodArgs caller;
    private URI callerEndpoint;
    public static final String BOUNDARY = "--JCLOUDS--";
    public static final TypeLiteral<ListenableFuture<Boolean>> futureBooleanLiteral = new TypeLiteral<ListenableFuture<Boolean>>(){};
    public static final TypeLiteral<ListenableFuture<String>> futureStringLiteral = new TypeLiteral<ListenableFuture<String>>(){};
    public static final TypeLiteral<ListenableFuture<Void>> futureVoidLiteral = new TypeLiteral<ListenableFuture<Void>>(){};
    public static final TypeLiteral<ListenableFuture<URI>> futureURILiteral = new TypeLiteral<ListenableFuture<URI>>(){};
    public static final TypeLiteral<ListenableFuture<InputStream>> futureInputStreamLiteral = new TypeLiteral<ListenableFuture<InputStream>>(){};
    public static final TypeLiteral<ListenableFuture<HttpResponse>> futureHttpResponseLiteral = new TypeLiteral<ListenableFuture<HttpResponse>>(){};
    private static final Predicate<Set<?>> notEmpty = new Predicate<Set<?>>(){

        @Override
        public boolean apply(Set<?> input) {
            return input.size() >= 1;
        }
    };

    static LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> createMethodToIndexOfParamToAnnotation(final Class<? extends Annotation> annotation) {
        return CacheBuilder.newBuilder().build(new CacheLoader<Method, LoadingCache<Integer, Set<Annotation>>>(){

            @Override
            public LoadingCache<Integer, Set<Annotation>> load(Method method) {
                return CacheBuilder.newBuilder().build(CacheLoader.from(new GetAnnotationsForMethodParameterIndex(method, annotation)));
            }
        });
    }

    @VisibleForTesting
    Function<HttpResponse, ?> createResponseParser(Method method, HttpRequest request) {
        return RestAnnotationProcessor.createResponseParser(this.parserFactory, this.injector, method, request);
    }

    @VisibleForTesting
    public static Function<HttpResponse, ?> createResponseParser(ParseSax.Factory parserFactory, Injector injector, Method method, HttpRequest request) {
        Class<ParseSax.HandlerWithResult<?>> handler = RestAnnotationProcessor.getSaxResponseParserClassOrNull(method);
        Function<HttpResponse, Object> transformer = handler != null ? parserFactory.create(injector.getInstance(handler)) : RestAnnotationProcessor.getTransformerForMethod(method, injector);
        if (transformer instanceof InvocationContext) {
            ((InvocationContext)((Object)transformer)).setContext(request);
        }
        return transformer;
    }

    public static Function<HttpResponse, ?> getTransformerForMethod(Method method, Injector injector) {
        Function<HttpResponse, Object> transformer;
        if (method.isAnnotationPresent(SelectJson.class)) {
            Type returnVal = RestAnnotationProcessor.getReturnTypeForMethod(method);
            if (method.isAnnotationPresent(OnlyElement.class)) {
                returnVal = Types.newParameterizedType(Set.class, new Type[]{returnVal});
            }
            transformer = new ParseFirstJsonValueNamed(injector.getInstance(GsonWrapper.class), TypeLiteral.get(returnVal), method.getAnnotation(SelectJson.class).value());
            if (method.isAnnotationPresent(OnlyElement.class)) {
                transformer = Functions.compose(new OnlyElementOrNull(), transformer);
            }
        } else {
            transformer = injector.getInstance(RestAnnotationProcessor.getParserOrThrowException(method));
        }
        return transformer;
    }

    @VisibleForTesting
    Function<Exception, ?> createExceptionParserOrThrowResourceNotFoundOn404IfNoAnnotation(Method method) {
        return RestAnnotationProcessor.createExceptionParserOrThrowResourceNotFoundOn404IfNoAnnotation(this.injector, method);
    }

    @VisibleForTesting
    public static Function<Exception, ?> createExceptionParserOrThrowResourceNotFoundOn404IfNoAnnotation(Injector injector, Method method) {
        ExceptionParser annotation = method.getAnnotation(ExceptionParser.class);
        if (annotation != null) {
            return injector.getInstance(annotation.value());
        }
        return injector.getInstance(MapHttp4xxCodesToExceptions.class);
    }

    @Inject
    public RestAnnotationProcessor(Injector injector, LoadingCache<Class<?>, Boolean> seedAnnotationCache, @ApiVersion String apiVersion, @BuildVersion String buildVersion, ParseSax.Factory parserFactory, HttpUtils utils, TypeLiteral<T> typeLiteral) throws ExecutionException {
        this.declaring = typeLiteral.getRawType();
        this.injector = injector;
        this.parserFactory = parserFactory;
        this.utils = utils;
        this.uriBuilderProvider = injector.getProvider(UriBuilder.class);
        this.seedAnnotationCache = seedAnnotationCache;
        seedAnnotationCache.get(this.declaring);
        this.skips = this.declaring.isAnnotationPresent(SkipEncoding.class) ? this.declaring.getAnnotation(SkipEncoding.class).value() : new char[0];
        this.apiVersion = apiVersion;
        this.buildVersion = buildVersion;
    }

    public Method getDelegateOrNull(Method in) {
        return delegationMap.get(new MethodKey(in));
    }

    public void setCaller(ClassMethodArgs caller) {
        try {
            this.seedAnnotationCache.get(caller.getMethod().getDeclaringClass());
        }
        catch (ExecutionException e) {
            Throwables.propagate(e);
        }
        this.caller = caller;
        try {
            this.callerEndpoint = RestAnnotationProcessor.getEndpointFor(caller.getMethod(), caller.getArgs(), this.injector);
        }
        catch (IllegalStateException e) {
        }
        catch (ExecutionException e) {
            Throwables.propagate(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public GeneratedHttpRequest<T> createRequest(Method method, Object ... args) {
        try {
            void var16_33;
            List<Part> parts;
            GeneratedHttpRequest.Builder<Object> requestBuilder;
            this.inputParamValidator.validateMethodParametersOrThrow(method, args);
            ClassMethodArgs cma = this.logger.isTraceEnabled() ? new ClassMethodArgs(method.getDeclaringClass(), method, args) : null;
            URI endpoint = this.callerEndpoint;
            try {
                if (endpoint == null) {
                    endpoint = RestAnnotationProcessor.getEndpointFor(method, args, this.injector);
                    this.logger.trace("using endpoint %s for %s", endpoint, cma);
                } else {
                    this.logger.trace("using endpoint %s from caller %s for %s", this.caller, endpoint, cma);
                }
            }
            catch (IllegalStateException e) {
                this.logger.trace("looking up default endpoint for %s", cma);
                endpoint = this.injector.getInstance(Key.get(URI.class, org.jclouds.location.Provider.class));
                this.logger.trace("using default endpoint %s for %s", endpoint, cma);
            }
            HttpRequest r = RestAnnotationProcessor.findHttpRequestInArgs(args);
            if (r != null) {
                requestBuilder = GeneratedHttpRequest.Builder.fromRequest(r);
                endpoint = r.getEndpoint();
            } else {
                requestBuilder = GeneratedHttpRequest.requestBuilder();
                requestBuilder.method(this.getHttpMethodOrConstantOrThrowException(method));
            }
            requestBuilder.declaring(this.declaring).javaMethod(method).args(args).skips(this.skips);
            requestBuilder.filters((List)this.getFiltersIfAnnotated(method));
            UriBuilder builder = this.uriBuilderProvider.get().uri(endpoint);
            LinkedHashMultimap<String, String> tokenValues = LinkedHashMultimap.create();
            tokenValues.put("jclouds.api-version", this.apiVersion);
            tokenValues.put("jclouds.build-version", this.buildVersion);
            tokenValues.putAll(this.addPathAndGetTokens(this.declaring, method, args, builder));
            Multimap<String, String> formParams = this.addFormParams(tokenValues.entries(), method, args);
            Multimap<String, String> queryParams = this.addQueryParams(tokenValues.entries(), method, args);
            Multimap<String, String> matrixParams = this.addMatrixParams(tokenValues.entries(), method, args);
            Multimap<String, String> headers = this.buildHeaders(tokenValues.entries(), method, args);
            if (r != null) {
                headers.putAll(r.getHeaders());
            }
            if (this.shouldAddHostHeader(method)) {
                StringBuilder hostHeader = new StringBuilder(endpoint.getHost());
                if (endpoint.getPort() != -1) {
                    hostHeader.append(":").append(endpoint.getPort());
                }
                headers.put("Host", hostHeader.toString());
            }
            org.jclouds.io.Payload payload = null;
            HttpRequestOptions options = this.findOptionsIn(method, args);
            if (options != null) {
                String string;
                this.injector.injectMembers(options);
                for (Map.Entry entry : options.buildRequestHeaders().entries()) {
                    headers.put((String)entry.getKey(), Strings2.replaceTokens((String)entry.getValue(), tokenValues.entries()));
                }
                for (Map.Entry entry : options.buildMatrixParameters().entries()) {
                    matrixParams.put((String)entry.getKey(), Strings2.replaceTokens((String)entry.getValue(), tokenValues.entries()));
                }
                for (Map.Entry entry : options.buildQueryParameters().entries()) {
                    queryParams.put((String)entry.getKey(), Strings2.replaceTokens((String)entry.getValue(), tokenValues.entries()));
                }
                for (Map.Entry entry : options.buildFormParameters().entries()) {
                    formParams.put((String)entry.getKey(), Strings2.replaceTokens((String)entry.getValue(), tokenValues.entries()));
                }
                String pathSuffix = options.buildPathSuffix();
                if (pathSuffix != null) {
                    builder.path(pathSuffix);
                }
                if ((string = options.buildStringPayload()) != null) {
                    payload = Payloads.newStringPayload(string);
                }
            }
            if (matrixParams.size() > 0) {
                for (String string : matrixParams.keySet()) {
                    builder.matrixParam(string, Lists.newArrayList(matrixParams.get(string)).toArray());
                }
            }
            if (queryParams.size() > 0) {
                builder.replaceQuery(ModifyRequest.makeQueryLine(queryParams, null, this.skips));
            }
            requestBuilder.headers((Multimap)RestAnnotationProcessor.filterOutContentHeaders(headers));
            try {
                requestBuilder.endpoint(builder.buildFromEncodedMap(Maps2.convertUnsafe(tokenValues)));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
            catch (UriBuilderException e) {
                throw new IllegalStateException(e);
            }
            if (payload == null) {
                payload = RestAnnotationProcessor.findPayloadInArgs(args);
            }
            if ((parts = this.getParts(method, args, Iterables.concat(tokenValues.entries(), formParams.entries()))).size() > 0) {
                if (formParams.size() > 0) {
                    parts = Lists.newLinkedList(Iterables.concat(Iterables.transform(formParams.entries(), ENTRY_TO_PART), parts));
                }
                payload = new MultipartForm(BOUNDARY, parts);
            } else if (formParams.size() > 0) {
                payload = Payloads.newUrlEncodedFormPayload(formParams, this.skips);
            } else if (headers.containsKey("Content-Type")) {
                if (payload == null) {
                    payload = Payloads.newByteArrayPayload(new byte[0]);
                }
                payload.getContentMetadata().setContentType(Iterables.get(headers.get("Content-Type"), 0));
            }
            if (payload != null) {
                requestBuilder.payload(payload);
            }
            HttpRequest httpRequest = requestBuilder.build();
            MapBinder mapBinder = this.getMapPayloadBinderOrNull(method, args);
            if (mapBinder != null) {
                Map<String, String> mapParams = this.buildPostParams(method, args);
                if (method.isAnnotationPresent(PayloadParams.class)) {
                    PayloadParams params = method.getAnnotation(PayloadParams.class);
                    this.addMapPayload(mapParams, params, headers.entries());
                }
                GeneratedHttpRequest generatedHttpRequest = (GeneratedHttpRequest)mapBinder.bindToRequest(httpRequest, mapParams);
            } else {
                GeneratedHttpRequest<T> generatedHttpRequest = this.decorateRequest((GeneratedHttpRequest<T>)httpRequest);
            }
            if (var16_33.getPayload() != null) {
                var16_33.getPayload().getContentMetadata().setPropertiesFromHttpHeaders(headers);
            }
            this.utils.checkRequestHasRequiredProperties((HttpRequest)var16_33);
            return var16_33;
        }
        catch (ExecutionException e) {
            Throwables.propagate(e);
            return null;
        }
    }

    public static Multimap<String, String> filterOutContentHeaders(Multimap<String, String> headers) {
        ImmutableMultimap.Builder<String, String> headersBuilder = ImmutableMultimap.builder();
        for (String header : Iterables.filter(headers.keySet(), Predicates.notNull())) {
            if (ContentMetadata.HTTP_HEADERS.contains(header)) continue;
            headersBuilder.putAll(header, (Iterable<String>)headers.get(header));
        }
        return headersBuilder.build();
    }

    private Multimap<String, String> addPathAndGetTokens(Class<?> clazz, Method method, Object[] args, UriBuilder builder) throws ExecutionException {
        if (clazz.isAnnotationPresent(Path.class)) {
            builder.path(clazz);
        }
        if (method.isAnnotationPresent(Path.class)) {
            builder.path(method);
        }
        return this.encodeValues(this.getPathParamKeyValues(method, args), this.skips);
    }

    public URI replaceQuery(URI in, String newQuery, @Nullable Comparator<Map.Entry<String, String>> sorter) {
        return RestAnnotationProcessor.replaceQuery(this.uriBuilderProvider, in, newQuery, sorter, this.skips);
    }

    public static URI replaceQuery(Provider<UriBuilder> uriBuilderProvider, URI in, String newQuery, @Nullable Comparator<Map.Entry<String, String>> sorter, char ... skips) {
        UriBuilder builder = uriBuilderProvider.get().uri(in);
        builder.replaceQuery(ModifyRequest.makeQueryLine(ModifyRequest.parseQueryToMap(newQuery), sorter, skips));
        return builder.build(new Object[0]);
    }

    private Multimap<String, String> addMatrixParams(Collection<Map.Entry<String, String>> tokenValues, Method method, Object ... args) throws ExecutionException {
        MatrixParams matrix;
        LinkedListMultimap<String, String> matrixMap = LinkedListMultimap.create();
        if (this.declaring.isAnnotationPresent(MatrixParams.class)) {
            matrix = this.declaring.getAnnotation(MatrixParams.class);
            this.addMatrix(matrixMap, matrix, tokenValues);
        }
        if (method.isAnnotationPresent(MatrixParams.class)) {
            matrix = method.getAnnotation(MatrixParams.class);
            this.addMatrix(matrixMap, matrix, tokenValues);
        }
        for (Map.Entry<String, String> matrix2 : this.getMatrixParamKeyValues(method, args).entries()) {
            matrixMap.put(matrix2.getKey(), Strings2.replaceTokens(matrix2.getValue(), tokenValues));
        }
        return matrixMap;
    }

    private Multimap<String, String> addFormParams(Collection<Map.Entry<String, String>> tokenValues, Method method, Object ... args) throws ExecutionException {
        FormParams form;
        LinkedListMultimap<String, String> formMap = LinkedListMultimap.create();
        if (this.declaring.isAnnotationPresent(FormParams.class)) {
            form = this.declaring.getAnnotation(FormParams.class);
            this.addForm(formMap, form, tokenValues);
        }
        if (method.isAnnotationPresent(FormParams.class)) {
            form = method.getAnnotation(FormParams.class);
            this.addForm(formMap, form, tokenValues);
        }
        for (Map.Entry<String, String> form2 : this.getFormParamKeyValues(method, args).entries()) {
            formMap.put(form2.getKey(), Strings2.replaceTokens(form2.getValue(), tokenValues));
        }
        return formMap;
    }

    private Multimap<String, String> addQueryParams(Collection<Map.Entry<String, String>> tokenValues, Method method, Object ... args) throws ExecutionException {
        QueryParams query;
        LinkedListMultimap<String, String> queryMap = LinkedListMultimap.create();
        if (this.declaring.isAnnotationPresent(QueryParams.class)) {
            query = this.declaring.getAnnotation(QueryParams.class);
            this.addQuery(queryMap, query, tokenValues);
        }
        if (method.isAnnotationPresent(QueryParams.class)) {
            query = method.getAnnotation(QueryParams.class);
            this.addQuery(queryMap, query, tokenValues);
        }
        for (Map.Entry<String, String> query2 : this.getQueryParamKeyValues(method, args).entries()) {
            queryMap.put(query2.getKey(), Strings2.replaceTokens(query2.getValue(), tokenValues));
        }
        return queryMap;
    }

    private void addForm(Multimap<String, String> formParams, FormParams form, Collection<Map.Entry<String, String>> tokenValues) {
        for (int i = 0; i < form.keys().length; ++i) {
            if (form.values()[i].equals("FORM_NULL")) {
                formParams.removeAll(form.keys()[i]);
                formParams.put(form.keys()[i], null);
                continue;
            }
            formParams.put(form.keys()[i], Strings2.replaceTokens(form.values()[i], tokenValues));
        }
    }

    private void addQuery(Multimap<String, String> queryParams, QueryParams query, Collection<Map.Entry<String, String>> tokenValues) {
        for (int i = 0; i < query.keys().length; ++i) {
            if (query.values()[i].equals("QUERY_NULL")) {
                queryParams.removeAll(query.keys()[i]);
                queryParams.put(query.keys()[i], null);
                continue;
            }
            queryParams.put(query.keys()[i], Strings2.replaceTokens(query.values()[i], tokenValues));
        }
    }

    private void addMatrix(Multimap<String, String> matrixParams, MatrixParams matrix, Collection<Map.Entry<String, String>> tokenValues) {
        for (int i = 0; i < matrix.keys().length; ++i) {
            if (matrix.values()[i].equals("MATRIX_NULL")) {
                matrixParams.removeAll(matrix.keys()[i]);
                matrixParams.put(matrix.keys()[i], null);
                continue;
            }
            matrixParams.put(matrix.keys()[i], Strings2.replaceTokens(matrix.values()[i], tokenValues));
        }
    }

    private void addMapPayload(Map<String, String> postParams, PayloadParams mapDefaults, Collection<Map.Entry<String, String>> tokenValues) {
        for (int i = 0; i < mapDefaults.keys().length; ++i) {
            if (mapDefaults.values()[i].equals("MAP_PAYLOAD_NULL")) {
                postParams.put(mapDefaults.keys()[i], null);
                continue;
            }
            postParams.put(mapDefaults.keys()[i], Strings2.replaceTokens(mapDefaults.values()[i], tokenValues));
        }
    }

    @VisibleForTesting
    List<HttpRequestFilter> getFiltersIfAnnotated(Method method) {
        HttpRequestFilter instance;
        ArrayList<HttpRequestFilter> filters = Lists.newArrayList();
        if (this.declaring.isAnnotationPresent(RequestFilters.class)) {
            for (Class<? extends HttpRequestFilter> clazz : this.declaring.getAnnotation(RequestFilters.class).value()) {
                instance = this.injector.getInstance(clazz);
                filters.add(instance);
                this.logger.trace("adding filter %s from annotation on %s", instance, this.declaring.getName());
            }
        }
        if (method.isAnnotationPresent(RequestFilters.class)) {
            if (method.isAnnotationPresent(OverrideRequestFilters.class)) {
                filters.clear();
            }
            for (Class<? extends HttpRequestFilter> clazz : method.getAnnotation(RequestFilters.class).value()) {
                instance = this.injector.getInstance(clazz);
                filters.add(instance);
                this.logger.trace("adding filter %s from annotation on %s", instance, method.getName());
            }
        }
        return filters;
    }

    @VisibleForTesting
    public static URI getEndpointInParametersOrNull(Method method, final Object[] args, Injector injector) throws ExecutionException {
        Map<Integer, Set<Annotation>> map = RestAnnotationProcessor.indexWithAtLeastOneAnnotation(method, methodToIndexOfParamToEndpointParamAnnotations);
        if (map.size() >= 1 && args.length > 0) {
            EndpointParam firstAnnotation = (EndpointParam)Iterables.get((Iterable)Iterables.get(map.values(), 0), 0);
            Function<Object, URI> parser = injector.getInstance(firstAnnotation.parser());
            if (map.size() == 1) {
                int index = map.keySet().iterator().next();
                try {
                    URI returnVal = parser.apply(args[index]);
                    Preconditions.checkArgument(returnVal != null, String.format("endpoint for [%s] not configured for %s", args[index], method));
                    return returnVal;
                }
                catch (NullPointerException e) {
                    throw new IllegalArgumentException(String.format("argument at index %d on method %s", index, method), e);
                }
            }
            TreeSet<Integer> keys = Sets.newTreeSet(map.keySet());
            Iterable<Object> argsToParse = Iterables.transform(keys, new Function<Integer, Object>(){

                @Override
                public Object apply(Integer from) {
                    return args[from];
                }
            });
            try {
                URI returnVal = parser.apply(argsToParse);
                Preconditions.checkArgument(returnVal != null, String.format("endpoint for [%s] not configured for %s", argsToParse, method));
                return returnVal;
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException(String.format("illegal argument in [%s] for method %s", argsToParse, method), e);
            }
        }
        return null;
    }

    public static URI getEndpointFor(Method method, Object[] args, Injector injector) throws ExecutionException {
        URI endpoint = RestAnnotationProcessor.getEndpointInParametersOrNull(method, args, injector);
        if (endpoint == null) {
            Endpoint annotation;
            if (method.isAnnotationPresent(Endpoint.class)) {
                annotation = method.getAnnotation(Endpoint.class);
            } else if (method.getDeclaringClass().isAnnotationPresent(Endpoint.class)) {
                annotation = method.getDeclaringClass().getAnnotation(Endpoint.class);
            } else {
                throw new IllegalStateException("no annotations on class or method: " + method);
            }
            endpoint = injector.getInstance(Key.get(URI.class, annotation.value()));
        }
        return RestAnnotationProcessor.addHostIfMissing(endpoint, injector.getInstance(Key.get(URI.class, org.jclouds.location.Provider.class)));
    }

    public static URI addHostIfMissing(URI original, URI withHost) {
        Preconditions.checkNotNull(withHost, "URI witHost cannot be null");
        Preconditions.checkArgument(withHost.getHost() != null, "URI withHost must have host:" + withHost);
        if (original == null) {
            return null;
        }
        if (original.getHost() != null) {
            return original;
        }
        return withHost.resolve(original);
    }

    public static Key<? extends Function<HttpResponse, ?>> getParserOrThrowException(Method method) {
        ResponseParser annotation = method.getAnnotation(ResponseParser.class);
        if (annotation == null) {
            if (method.getReturnType().equals(Void.TYPE) || TypeLiteral.get(method.getGenericReturnType()).equals(futureVoidLiteral)) {
                return Key.get(ReleasePayloadAndReturn.class);
            }
            if (method.getReturnType().equals(Boolean.TYPE) || method.getReturnType().equals(Boolean.class) || TypeLiteral.get(method.getGenericReturnType()).equals(futureBooleanLiteral)) {
                return Key.get(ReturnTrueIf2xx.class);
            }
            if (method.getReturnType().equals(InputStream.class) || TypeLiteral.get(method.getGenericReturnType()).equals(futureInputStreamLiteral)) {
                return Key.get(ReturnInputStream.class);
            }
            if (method.getReturnType().equals(HttpResponse.class) || TypeLiteral.get(method.getGenericReturnType()).equals(futureHttpResponseLiteral)) {
                return Key.get(IdentityFunction.class);
            }
            if (RestAnnotationProcessor.getAcceptHeadersOrNull(method).contains("application/json")) {
                return RestAnnotationProcessor.getJsonParserKeyForMethod(method);
            }
            if (RestAnnotationProcessor.getAcceptHeadersOrNull(method).contains("application/xml") || method.isAnnotationPresent(JAXBResponseParser.class)) {
                return RestAnnotationProcessor.getJAXBParserKeyForMethod(method);
            }
            if (method.getReturnType().equals(String.class) || TypeLiteral.get(method.getGenericReturnType()).equals(futureStringLiteral)) {
                return Key.get(ReturnStringIf2xx.class);
            }
            if (method.getReturnType().equals(URI.class) || TypeLiteral.get(method.getGenericReturnType()).equals(futureURILiteral)) {
                return Key.get(ParseURIFromListOrLocationHeaderIf20x.class);
            }
            throw new IllegalStateException("You must specify a ResponseParser annotation on: " + method.toString());
        }
        return Key.get(annotation.value());
    }

    public static Key<? extends Function<HttpResponse, ?>> getJsonParserKeyForMethod(Method method) {
        Type returnVal = RestAnnotationProcessor.getReturnTypeForMethod(method);
        return RestAnnotationProcessor.getJsonParserKeyForMethodAnType(method, returnVal);
    }

    public static Key<? extends Function<HttpResponse, ?>> getJAXBParserKeyForMethod(Method method) {
        Type returnVal = RestAnnotationProcessor.getReturnTypeForMethod(method);
        ParameterizedType parserType = Types.newParameterizedType(ParseXMLWithJAXB.class, new Type[]{returnVal});
        return Key.get(parserType);
    }

    public static Type getReturnTypeForMethod(Method method) {
        Type returnVal;
        if (method.getReturnType().getTypeParameters().length == 0) {
            returnVal = method.getReturnType();
        } else if (method.getReturnType().equals(ListenableFuture.class)) {
            ParameterizedType futureType = (ParameterizedType)method.getGenericReturnType();
            returnVal = futureType.getActualTypeArguments()[0];
            if (returnVal instanceof WildcardType) {
                returnVal = ((WildcardType)WildcardType.class.cast(returnVal)).getUpperBounds()[0];
            }
        } else {
            returnVal = method.getGenericReturnType();
        }
        return returnVal;
    }

    public static Key<? extends Function<HttpResponse, ?>> getJsonParserKeyForMethodAnType(Method method, Type returnVal) {
        ParameterizedType parserType = method.isAnnotationPresent(Unwrap.class) ? Types.newParameterizedType(UnwrapOnlyJsonValue.class, new Type[]{returnVal}) : Types.newParameterizedType(ParseJson.class, new Type[]{returnVal});
        return Key.get(parserType);
    }

    public static Class<? extends ParseSax.HandlerWithResult<?>> getSaxResponseParserClassOrNull(Method method) {
        XMLResponseParser annotation = method.getAnnotation(XMLResponseParser.class);
        if (annotation != null) {
            return annotation.value();
        }
        return null;
    }

    public MapBinder getMapPayloadBinderOrNull(Method method, Object ... args) {
        if (args != null) {
            for (Object arg : args) {
                if (arg instanceof Object[]) {
                    Object[] postBinders = (Object[])arg;
                    if (postBinders.length == 0) continue;
                    if (postBinders.length == 1) {
                        if (!(postBinders[0] instanceof MapBinder)) continue;
                        MapBinder binder = (MapBinder)postBinders[0];
                        this.injector.injectMembers(binder);
                        return binder;
                    }
                    if (!(postBinders[0] instanceof MapBinder)) continue;
                    throw new IllegalArgumentException("we currently do not support multiple varargs postBinders in: " + method.getName());
                }
                if (!(arg instanceof MapBinder)) continue;
                MapBinder binder = (MapBinder)arg;
                this.injector.injectMembers(binder);
                return binder;
            }
        }
        if (method.isAnnotationPresent(org.jclouds.rest.annotations.MapBinder.class)) {
            return this.injector.getInstance(method.getAnnotation(org.jclouds.rest.annotations.MapBinder.class).value());
        }
        if (method.isAnnotationPresent(Payload.class)) {
            return this.injector.getInstance(BindMapToStringPayload.class);
        }
        return null;
    }

    public static Set<String> getHttpMethods(Method method) {
        ImmutableSet.Builder methodsBuilder = ImmutableSet.builder();
        for (Annotation annotation : method.getAnnotations()) {
            HttpMethod http = annotation.annotationType().getAnnotation(HttpMethod.class);
            if (http == null) continue;
            methodsBuilder.add(http.value());
        }
        ImmutableCollection methods = methodsBuilder.build();
        return methods.size() == 0 ? null : methods;
    }

    public String getHttpMethodOrConstantOrThrowException(Method method) {
        Set<String> requests = RestAnnotationProcessor.getHttpMethods(method);
        if (requests == null || requests.size() != 1) {
            throw new IllegalStateException("You must use at least one, but no more than one http method or pathparam annotation on: " + method.toString());
        }
        return requests.iterator().next();
    }

    public boolean shouldAddHostHeader(Method method) {
        return this.declaring.isAnnotationPresent(VirtualHost.class) || method.isAnnotationPresent(VirtualHost.class);
    }

    public GeneratedHttpRequest<T> decorateRequest(GeneratedHttpRequest<T> request) throws NegativeArraySizeException, ExecutionException {
        block0: for (Map.Entry<Integer, Set<?>> entry : Iterables.concat(Maps.filterValues(methodToIndexOfParamToBinderParamAnnotation.get(request.getJavaMethod()).asMap(), notEmpty).entrySet(), Maps.filterValues(methodToIndexOfParamToWrapWithAnnotation.get(request.getJavaMethod()).asMap(), notEmpty).entrySet())) {
            Annotation[] annotations;
            boolean shouldBreak = false;
            Annotation annotation = (Annotation)Iterables.get((Iterable)entry.getValue(), 0);
            Binder binder = annotation instanceof BinderParam ? this.injector.getInstance(((BinderParam)BinderParam.class.cast(annotation)).value()) : this.injector.getInstance(BindToJsonPayloadWrappedWith.Factory.class).create(((WrapWith)WrapWith.class.cast(annotation)).value());
            if (request.getArgs().size() >= entry.getKey() + 1 && request.getArgs().get(entry.getKey()) != null) {
                Object[] input;
                Class<?> parameterType = request.getJavaMethod().getParameterTypes()[entry.getKey()];
                Class<?> argType = request.getArgs().get(entry.getKey()).getClass();
                if (!argType.isArray() && request.getJavaMethod().isVarArgs() && parameterType.isArray()) {
                    int arrayLength = request.getArgs().size() - request.getJavaMethod().getParameterTypes().length + 1;
                    if (arrayLength == 0) break;
                    input = (Object[])Array.newInstance(request.getArgs().get(entry.getKey()).getClass(), arrayLength);
                    System.arraycopy(request.getArgs().toArray(), entry.getKey(), input, 0, arrayLength);
                    shouldBreak = true;
                } else if (argType.isArray() && request.getJavaMethod().isVarArgs() && parameterType.isArray()) {
                    input = request.getArgs().get(entry.getKey());
                } else {
                    input = request.getArgs().get(entry.getKey());
                    if (input.getClass().isArray()) {
                        Object[] payloadArray = input;
                        Object[] objectArray = input = payloadArray.length > 0 ? payloadArray[0] : null;
                    }
                }
                if (input != null) {
                    request = binder.bindToRequest(request, input);
                }
                if (!shouldBreak) continue;
                break;
            }
            if (entry.getKey() >= request.getJavaMethod().getParameterAnnotations().length) {
                throw new IllegalArgumentException("Argument index " + (entry.getKey() + 1) + " is out of bounds for method " + request.getJavaMethod());
            }
            if (request.getJavaMethod().isVarArgs() && entry.getKey() + 1 == request.getJavaMethod().getParameterTypes().length) continue;
            for (Annotation a : annotations = request.getJavaMethod().getParameterAnnotations()[entry.getKey()]) {
                if (Nullable.class.isAssignableFrom(a.annotationType())) continue block0;
            }
            Preconditions.checkNotNull(null, request.getJavaMethod().getName() + " parameter " + (entry.getKey() + 1));
        }
        return request;
    }

    public static Map<Integer, Set<Annotation>> indexWithOnlyOneAnnotation(Method method, String description, LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> toRefine) throws ExecutionException {
        Map<Integer, Set<Annotation>> indexToPayloadAnnotation = RestAnnotationProcessor.indexWithAtLeastOneAnnotation(method, toRefine);
        if (indexToPayloadAnnotation.size() > 1) {
            throw new IllegalStateException(String.format("You must not specify more than one %s annotation on: %s; found %s", description, method.toString(), indexToPayloadAnnotation));
        }
        return indexToPayloadAnnotation;
    }

    private static Map<Integer, Set<Annotation>> indexWithAtLeastOneAnnotation(Method method, LoadingCache<Method, LoadingCache<Integer, Set<Annotation>>> toRefine) throws ExecutionException {
        Map<Integer, Set<Annotation>> indexToPayloadAnnotation = Maps.filterValues(toRefine.get(method).asMap(), new Predicate<Set<Annotation>>(){

            @Override
            public boolean apply(Set<Annotation> input) {
                return input.size() == 1;
            }
        });
        return indexToPayloadAnnotation;
    }

    private HttpRequestOptions findOptionsIn(Method method, Object ... args) throws ExecutionException {
        for (int index : methodToIndexesOfOptions.get(method)) {
            if (args.length < index + 1) continue;
            if (args[index] instanceof Object[]) {
                Object[] options = (Object[])args[index];
                if (options.length == 0) continue;
                if (options.length == 1) {
                    if (!(options[0] instanceof HttpRequestOptions)) continue;
                    HttpRequestOptions binder = (HttpRequestOptions)options[0];
                    this.injector.injectMembers(binder);
                    return binder;
                }
                if (!(options[0] instanceof HttpRequestOptions)) continue;
                throw new IllegalArgumentException("we currently do not support multiple varargs options in: " + method.getName());
            }
            return (HttpRequestOptions)args[index];
        }
        return null;
    }

    public Multimap<String, String> buildHeaders(Collection<Map.Entry<String, String>> tokenValues, Method method, Object ... args) throws ExecutionException {
        LinkedHashMultimap<String, String> headers = LinkedHashMultimap.create();
        this.addHeaderIfAnnotationPresentOnMethod(headers, method, tokenValues);
        LoadingCache<Integer, Set<Annotation>> indexToHeaderParam = methodToIndexOfParamToHeaderParamAnnotations.get(method);
        for (Map.Entry entry : indexToHeaderParam.asMap().entrySet()) {
            for (Annotation key : (Set)entry.getValue()) {
                String value = args[(Integer)entry.getKey()].toString();
                value = Strings2.replaceTokens(value, tokenValues);
                headers.put(((HeaderParam)key).value(), value);
            }
        }
        this.addProducesIfPresentOnTypeOrMethod(headers, method);
        this.addConsumesIfPresentOnTypeOrMethod(headers, method);
        return headers;
    }

    void addConsumesIfPresentOnTypeOrMethod(Multimap<String, String> headers, Method method) {
        List<String> accept = RestAnnotationProcessor.getAcceptHeadersOrNull(method);
        if (accept.size() > 0) {
            headers.replaceValues("Accept", accept);
        }
    }

    private static List<String> getAcceptHeadersOrNull(Method method) {
        Consumes header;
        List<String> accept = Collections.emptyList();
        if (method.getDeclaringClass().isAnnotationPresent(Consumes.class)) {
            header = method.getDeclaringClass().getAnnotation(Consumes.class);
            accept = Arrays.asList(header.value());
        }
        if (method.isAnnotationPresent(Consumes.class)) {
            header = method.getAnnotation(Consumes.class);
            accept = Arrays.asList(header.value());
        }
        return accept;
    }

    void addProducesIfPresentOnTypeOrMethod(Multimap<String, String> headers, Method method) {
        Produces header;
        if (this.declaring.isAnnotationPresent(Produces.class)) {
            header = this.declaring.getAnnotation(Produces.class);
            headers.replaceValues("Content-Type", Arrays.asList(header.value()));
        }
        if (method.isAnnotationPresent(Produces.class)) {
            header = method.getAnnotation(Produces.class);
            headers.replaceValues("Content-Type", Arrays.asList(header.value()));
        }
    }

    public void addHeaderIfAnnotationPresentOnMethod(Multimap<String, String> headers, Method method, Collection<Map.Entry<String, String>> tokenValues) {
        Headers header;
        if (this.declaring.isAnnotationPresent(Headers.class)) {
            header = this.declaring.getAnnotation(Headers.class);
            this.addHeader(headers, header, tokenValues);
        }
        if (method.isAnnotationPresent(Headers.class)) {
            header = method.getAnnotation(Headers.class);
            this.addHeader(headers, header, tokenValues);
        }
    }

    private void addHeader(Multimap<String, String> headers, Headers header, Collection<Map.Entry<String, String>> tokenValues) {
        for (int i = 0; i < header.keys().length; ++i) {
            String value = header.values()[i];
            value = Strings2.replaceTokens(value, tokenValues);
            headers.put(header.keys()[i], value);
        }
    }

    List<? extends Part> getParts(Method method, Object[] args, Iterable<Map.Entry<String, String>> iterable) throws ExecutionException {
        LinkedList<Part> parts = Lists.newLinkedList();
        LoadingCache<Integer, Set<Annotation>> indexToPartParam = methodToIndexOfParamToPartParamAnnotations.get(method);
        for (Map.Entry entry : indexToPartParam.asMap().entrySet()) {
            for (Annotation key : (Set)entry.getValue()) {
                PartParam param = (PartParam)key;
                Part.PartOptions options = new Part.PartOptions();
                if (!"---NO_CONTENT_TYPE---".equals(param.contentType())) {
                    options.contentType(param.contentType());
                }
                if (!"---NO_FILENAME---".equals(param.filename())) {
                    options.filename(Strings2.replaceTokens(param.filename(), iterable));
                }
                Object arg = args[(Integer)entry.getKey()];
                Preconditions.checkNotNull(arg, param.name());
                Part part = Part.create(param.name(), Payloads.newPayload(arg), options);
                parts.add(part);
            }
        }
        return parts;
    }

    public static HttpRequest findHttpRequestInArgs(Object[] args) {
        if (args == null) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof HttpRequest)) continue;
            return (HttpRequest)HttpRequest.class.cast(args[i]);
        }
        return null;
    }

    public static org.jclouds.io.Payload findPayloadInArgs(Object[] args) {
        if (args == null) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof org.jclouds.io.Payload) {
                return (org.jclouds.io.Payload)org.jclouds.io.Payload.class.cast(args[i]);
            }
            if (!(args[i] instanceof PayloadEnclosing)) continue;
            return ((PayloadEnclosing)PayloadEnclosing.class.cast(args[i])).getPayload();
        }
        return null;
    }

    private Multimap<String, String> getPathParamKeyValues(Method method, Object ... args) throws ExecutionException {
        LinkedHashMultimap<String, String> pathParamValues = LinkedHashMultimap.create();
        LoadingCache<Integer, Set<Annotation>> indexToPathParam = methodToIndexOfParamToPathParamAnnotations.get(method);
        LoadingCache<Integer, Set<Annotation>> indexToParamExtractor = methodToIndexOfParamToParamParserAnnotations.get(method);
        for (Map.Entry entry : indexToPathParam.asMap().entrySet()) {
            for (Annotation key : (Set)entry.getValue()) {
                String paramValue;
                Set<Annotation> extractors = indexToParamExtractor.get((Integer)entry.getKey());
                String paramKey = ((PathParam)key).value();
                if (extractors != null && extractors.size() > 0) {
                    ParamParser extractor = (ParamParser)extractors.iterator().next();
                    paramValue = this.injector.getInstance(extractor.value()).apply(args[(Integer)entry.getKey()]);
                } else {
                    paramValue = args[(Integer)entry.getKey()].toString();
                }
                pathParamValues.put(paramKey, paramValue);
            }
        }
        if (method.isAnnotationPresent(PathParam.class) && method.isAnnotationPresent(ParamParser.class)) {
            String paramKey = method.getAnnotation(PathParam.class).value();
            String paramValue = this.injector.getInstance(method.getAnnotation(ParamParser.class).value()).apply(args);
            pathParamValues.put(paramKey, paramValue);
        }
        return pathParamValues;
    }

    private Multimap<String, String> encodeValues(Multimap<String, String> unencoded, char ... skips) {
        LinkedHashMultimap<String, String> encoded = LinkedHashMultimap.create();
        for (Map.Entry<String, String> entry : unencoded.entries()) {
            encoded.put(entry.getKey(), Strings2.urlEncode(entry.getValue(), skips));
        }
        return encoded;
    }

    private Multimap<String, String> getMatrixParamKeyValues(Method method, Object ... args) throws ExecutionException {
        LinkedHashMultimap<String, String> matrixParamValues = LinkedHashMultimap.create();
        LoadingCache<Integer, Set<Annotation>> indexToMatrixParam = methodToIndexOfParamToMatrixParamAnnotations.get(method);
        LoadingCache<Integer, Set<Annotation>> indexToParamExtractor = methodToIndexOfParamToParamParserAnnotations.get(method);
        for (Map.Entry entry : indexToMatrixParam.asMap().entrySet()) {
            for (Annotation key : (Set)entry.getValue()) {
                String paramValue;
                Set<Annotation> extractors = indexToParamExtractor.get((Integer)entry.getKey());
                String paramKey = ((MatrixParam)key).value();
                if (extractors != null && extractors.size() > 0) {
                    ParamParser extractor = (ParamParser)extractors.iterator().next();
                    paramValue = this.injector.getInstance(extractor.value()).apply(args[(Integer)entry.getKey()]);
                } else {
                    paramValue = args[(Integer)entry.getKey()].toString();
                }
                matrixParamValues.put(paramKey, paramValue);
            }
        }
        if (method.isAnnotationPresent(MatrixParam.class) && method.isAnnotationPresent(ParamParser.class)) {
            String paramKey = method.getAnnotation(MatrixParam.class).value();
            String paramValue = this.injector.getInstance(method.getAnnotation(ParamParser.class).value()).apply(args);
            matrixParamValues.put(paramKey, paramValue);
        }
        return matrixParamValues;
    }

    private Multimap<String, String> getFormParamKeyValues(Method method, Object ... args) throws ExecutionException {
        LinkedHashMultimap<String, String> formParamValues = LinkedHashMultimap.create();
        LoadingCache<Integer, Set<Annotation>> indexToFormParam = methodToIndexOfParamToFormParamAnnotations.get(method);
        LoadingCache<Integer, Set<Annotation>> indexToParamExtractor = methodToIndexOfParamToParamParserAnnotations.get(method);
        for (Map.Entry entry : indexToFormParam.asMap().entrySet()) {
            for (Annotation key : (Set)entry.getValue()) {
                String paramValue;
                Set<Annotation> extractors = indexToParamExtractor.get((Integer)entry.getKey());
                String paramKey = ((FormParam)key).value();
                if (extractors != null && extractors.size() > 0) {
                    ParamParser extractor = (ParamParser)extractors.iterator().next();
                    paramValue = this.injector.getInstance(extractor.value()).apply(args[(Integer)entry.getKey()]);
                } else {
                    Object pvo = args[(Integer)entry.getKey()];
                    Preconditions.checkNotNull(pvo, paramKey);
                    paramValue = pvo.toString();
                }
                formParamValues.put(paramKey, paramValue);
            }
        }
        if (method.isAnnotationPresent(FormParam.class) && method.isAnnotationPresent(ParamParser.class)) {
            String paramKey = method.getAnnotation(FormParam.class).value();
            String paramValue = this.injector.getInstance(method.getAnnotation(ParamParser.class).value()).apply(args);
            formParamValues.put(paramKey, paramValue);
        }
        return formParamValues;
    }

    private Multimap<String, String> getQueryParamKeyValues(Method method, Object ... args) throws ExecutionException {
        LinkedHashMultimap<String, String> queryParamValues = LinkedHashMultimap.create();
        LoadingCache<Integer, Set<Annotation>> indexToQueryParam = methodToIndexOfParamToQueryParamAnnotations.get(method);
        LoadingCache<Integer, Set<Annotation>> indexToParamExtractor = methodToIndexOfParamToParamParserAnnotations.get(method);
        for (Map.Entry entry : indexToQueryParam.asMap().entrySet()) {
            for (Annotation key : (Set)entry.getValue()) {
                String paramValue;
                Set<Annotation> extractors = indexToParamExtractor.get((Integer)entry.getKey());
                String paramKey = ((QueryParam)key).value();
                if (extractors != null && extractors.size() > 0) {
                    ParamParser extractor = (ParamParser)extractors.iterator().next();
                    paramValue = this.injector.getInstance(extractor.value()).apply(args[(Integer)entry.getKey()]);
                } else {
                    paramValue = args[(Integer)entry.getKey()].toString();
                }
                queryParamValues.put(paramKey, paramValue);
            }
        }
        if (method.isAnnotationPresent(QueryParam.class) && method.isAnnotationPresent(ParamParser.class)) {
            String paramKey = method.getAnnotation(QueryParam.class).value();
            String paramValue = this.injector.getInstance(method.getAnnotation(ParamParser.class).value()).apply(args);
            queryParamValues.put(paramKey, paramValue);
        }
        return queryParamValues;
    }

    private Map<String, String> buildPostParams(Method method, Object ... args) throws ExecutionException {
        HashMap<String, String> postParams = Maps.newHashMap();
        LoadingCache<Integer, Set<Annotation>> indexToPathParam = methodToIndexOfParamToPostParamAnnotations.get(method);
        LoadingCache<Integer, Set<Annotation>> indexToParamExtractor = methodToIndexOfParamToParamParserAnnotations.get(method);
        for (Map.Entry entry : indexToPathParam.asMap().entrySet()) {
            for (Annotation key : (Set)entry.getValue()) {
                String paramValue;
                Set<Annotation> extractors = indexToParamExtractor.get((Integer)entry.getKey());
                String paramKey = ((PayloadParam)key).value();
                if (extractors != null && extractors.size() > 0) {
                    ParamParser extractor = (ParamParser)extractors.iterator().next();
                    paramValue = this.injector.getInstance(extractor.value()).apply(args[(Integer)entry.getKey()]);
                } else {
                    paramValue = args[(Integer)entry.getKey()] != null ? args[(Integer)entry.getKey()].toString() : null;
                }
                postParams.put(paramKey, paramValue);
            }
        }
        return postParams;
    }

    public static class MethodKey {
        private final String name;
        private final int parametersTypeHashCode;
        private final Package declaringPackage;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.declaringPackage == null ? 0 : this.declaringPackage.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.parametersTypeHashCode;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (this.declaringPackage == null ? other.declaringPackage != null : !this.declaringPackage.equals(other.declaringPackage)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.parametersTypeHashCode == other.parametersTypeHashCode;
        }

        public MethodKey(Method method) {
            this.name = method.getName();
            this.declaringPackage = method.getDeclaringClass().getPackage();
            int parametersTypeHashCode = 0;
            for (Class<?> param : method.getParameterTypes()) {
                parametersTypeHashCode += param.hashCode();
            }
            this.parametersTypeHashCode = parametersTypeHashCode;
        }
    }

    static class GetAnnotationsForMethodParameterIndex
    implements Function<Integer, Set<Annotation>> {
        private final Method method;
        private final Class<?> clazz;

        protected GetAnnotationsForMethodParameterIndex(Method method, Class<?> clazz) {
            this.method = method;
            this.clazz = clazz;
        }

        @Override
        public Set<Annotation> apply(Integer index) {
            return ImmutableSet.copyOf(Collections2.filter(ImmutableList.copyOf(this.method.getParameterAnnotations()[index]), new Predicate<Annotation>(){

                @Override
                public boolean apply(Annotation input) {
                    return input.annotationType().equals(GetAnnotationsForMethodParameterIndex.this.clazz);
                }
            }));
        }
    }
}

