/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.rest.annotations.ExceptionParser;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.MatrixParams;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rimuhosting.miro.binder.CreateServerOptions;
import org.jclouds.rimuhosting.miro.binder.RimuHostingRebootJsonBinder;
import org.jclouds.rimuhosting.miro.domain.Image;
import org.jclouds.rimuhosting.miro.domain.NewServerResponse;
import org.jclouds.rimuhosting.miro.domain.PricingPlan;
import org.jclouds.rimuhosting.miro.domain.Server;
import org.jclouds.rimuhosting.miro.domain.ServerInfo;
import org.jclouds.rimuhosting.miro.filters.RimuHostingAuthentication;
import org.jclouds.rimuhosting.miro.functions.ParseDestroyResponseFromJsonResponse;
import org.jclouds.rimuhosting.miro.functions.ParseImagesFromJsonResponse;
import org.jclouds.rimuhosting.miro.functions.ParsePricingPlansFromJsonResponse;
import org.jclouds.rimuhosting.miro.functions.ParseRimuHostingException;
import org.jclouds.rimuhosting.miro.functions.ParseServerFromJsonResponse;
import org.jclouds.rimuhosting.miro.functions.ParseServerInfoFromJsonResponse;
import org.jclouds.rimuhosting.miro.functions.ParseServersFromJsonResponse;

@RequestFilters(value={RimuHostingAuthentication.class})
@VirtualHost
public interface RimuHostingAsyncClient {
    @GET
    @Path(value="/distributions")
    @ResponseParser(value=ParseImagesFromJsonResponse.class)
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ParseRimuHostingException.class)
    public ListenableFuture<Set<Image>> getImageList();

    @GET
    @Path(value="/orders")
    @ResponseParser(value=ParseServersFromJsonResponse.class)
    @MatrixParams(keys={"include_inactive"}, values={"N"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ParseRimuHostingException.class)
    public ListenableFuture<Set<Server>> getServerList();

    @GET
    @Path(value="/pricing-plans")
    @MatrixParams(keys={"server-type"}, values={"VPS"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ParseRimuHostingException.class)
    @ResponseParser(value=ParsePricingPlansFromJsonResponse.class)
    public ListenableFuture<Set<PricingPlan>> getPricingPlanList();

    @POST
    @Path(value="/orders/new-vps")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ExceptionParser(value=ParseRimuHostingException.class)
    @Unwrap
    @MapBinder(value=CreateServerOptions.class)
    public ListenableFuture<NewServerResponse> createServer(@PayloadParam(value="name") String var1, @PayloadParam(value="imageId") String var2, @PayloadParam(value="planId") String var3, CreateServerOptions ... var4);

    @GET
    @Path(value="/orders/order-{id}-blah")
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseServerFromJsonResponse.class)
    @ExceptionParser(value=ParseRimuHostingException.class)
    public ListenableFuture<Server> getServer(@PathParam(value="id") Long var1);

    @PUT
    @Path(value="/orders/order-{id}-blah/vps/running-state")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseServerInfoFromJsonResponse.class)
    @MapBinder(value=RimuHostingRebootJsonBinder.class)
    @ExceptionParser(value=ParseRimuHostingException.class)
    public ListenableFuture<ServerInfo> restartServer(@PathParam(value="id") Long var1);

    @DELETE
    @Path(value="/orders/order-{id}-blah/vps")
    @Consumes(value={"application/json"})
    @ResponseParser(value=ParseDestroyResponseFromJsonResponse.class)
    @ExceptionParser(value=ParseRimuHostingException.class)
    public ListenableFuture<List<String>> destroyServer(@PathParam(value="id") Long var1);
}

