/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro;

import java.util.Properties;
import org.jclouds.PropertiesBuilder;
import org.jclouds.concurrent.Timeout;
import org.jclouds.rimuhosting.miro.RimuHostingClient;

public class RimuHostingPropertiesBuilder
extends PropertiesBuilder {
    @Override
    protected Properties defaultProperties() {
        Properties properties = super.defaultProperties();
        properties.setProperty("jclouds.zones", "DCAUCKLAND,DCLONDON,DCDALLAS,DCSYDNEY");
        properties.setProperty("jclouds.iso3166-codes", "NZ-AUK,US-TX,AU-NSW,GB-LND");
        properties.setProperty("jclouds.zone.DCAUCKLAND.iso3166-codes", "NZ-AUK");
        properties.setProperty("jclouds.zone.DCLONDON.iso3166-codes", "GB-LND");
        properties.setProperty("jclouds.zone.DCDALLAS.iso3166-codes", "US-TX");
        properties.setProperty("jclouds.zone.DCSYDNEY.iso3166-codes", "AU-NSW");
        properties.setProperty("jclouds.api-version", "TODO");
        properties.setProperty("jclouds.endpoint", "https://api.rimuhosting.com/r");
        properties.setProperty("jclouds.rimuhosting.defaultdc", "DCDALLAS");
        Timeout timeout = RimuHostingClient.class.getAnnotation(Timeout.class);
        long timeoutMillis = timeout.timeUnit().toMillis(timeout.duration());
        properties.setProperty("jclouds.so-timeout", timeoutMillis + "");
        properties.setProperty("jclouds.connection-timeout", timeoutMillis + "");
        properties.setProperty("jclouds.compute.timeout.node-terminated", "60000");
        return properties;
    }

    public RimuHostingPropertiesBuilder(Properties properties) {
        super(properties);
    }
}

