/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.compute.config;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeState;
import org.jclouds.compute.internal.ComputeServiceContextImpl;
import org.jclouds.rimuhosting.miro.RimuHostingAsyncClient;
import org.jclouds.rimuhosting.miro.RimuHostingClient;
import org.jclouds.rimuhosting.miro.compute.functions.ServerToNodeMetadata;
import org.jclouds.rimuhosting.miro.domain.Server;
import org.jclouds.rimuhosting.miro.domain.internal.RunningState;

public class RimuHostingComputeServiceDependenciesModule
extends AbstractModule {
    @VisibleForTesting
    static final Map<RunningState, NodeState> runningStateToNodeState = ImmutableMap.builder().put(RunningState.RUNNING, NodeState.RUNNING).put(RunningState.NOTRUNNING, NodeState.SUSPENDED).put(RunningState.POWERCYCLING, NodeState.PENDING).put(RunningState.RESTARTING, NodeState.PENDING).put(RunningState.UNRECOGNIZED, NodeState.UNRECOGNIZED).build();

    @Override
    protected void configure() {
        this.bind(new TypeLiteral<Function<Server, NodeMetadata>>(){}).to(ServerToNodeMetadata.class);
        this.bind(new TypeLiteral<ComputeServiceContext>(){}).to((TypeLiteral<ComputeServiceContext>)new TypeLiteral<ComputeServiceContextImpl<RimuHostingClient, RimuHostingAsyncClient>>(){}).in(Scopes.SINGLETON);
        this.bind(new TypeLiteral<Function<Server, Iterable<String>>>(){}).to(ServerToPublicAddresses.class);
    }

    @Singleton
    @Provides
    Map<RunningState, NodeState> provideServerToNodeState() {
        return runningStateToNodeState;
    }

    @Singleton
    private static class ServerToPublicAddresses
    implements Function<Server, Iterable<String>> {
        private ServerToPublicAddresses() {
        }

        @Override
        public Iterable<String> apply(Server server) {
            return server.getIpAddresses() == null ? ImmutableSet.of() : Iterables.concat(ImmutableList.of(server.getIpAddresses().getPrimaryIp()), server.getIpAddresses().getSecondaryIps());
        }
    }
}

