/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.compute.strategy;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.DestroyNodeStrategy;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.rimuhosting.miro.RimuHostingClient;

@Singleton
public class RimuHostingDestroyNodeStrategy
implements DestroyNodeStrategy {
    private final RimuHostingClient client;
    private final GetNodeMetadataStrategy getNode;

    @Inject
    protected RimuHostingDestroyNodeStrategy(RimuHostingClient client, GetNodeMetadataStrategy getNode) {
        this.client = client;
        this.getNode = getNode;
    }

    @Override
    public NodeMetadata destroyNode(String id) {
        Long serverId = Long.parseLong(id);
        this.client.destroyServer(serverId);
        return this.getNode.getNode(id);
    }
}

