/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.compute.strategy;

import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.rimuhosting.miro.RimuHostingClient;
import org.jclouds.rimuhosting.miro.domain.Server;

@Singleton
public class RimuHostingGetNodeMetadataStrategy
implements GetNodeMetadataStrategy {
    private final RimuHostingClient client;
    private final Function<Server, NodeMetadata> serverToNodeMetadata;

    @Inject
    protected RimuHostingGetNodeMetadataStrategy(RimuHostingClient client, Function<Server, NodeMetadata> serverToNodeMetadata) {
        this.client = client;
        this.serverToNodeMetadata = serverToNodeMetadata;
    }

    @Override
    public NodeMetadata getNode(String id) {
        long serverId = Long.parseLong(id);
        Server server = this.client.getServer(serverId);
        return server == null ? null : this.serverToNodeMetadata.apply(server);
    }
}

