/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.compute.strategy;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.strategy.GetNodeMetadataStrategy;
import org.jclouds.compute.strategy.RebootNodeStrategy;
import org.jclouds.compute.strategy.ResumeNodeStrategy;
import org.jclouds.compute.strategy.SuspendNodeStrategy;
import org.jclouds.rimuhosting.miro.RimuHostingClient;

@Singleton
public class RimuHostingLifeCycleStrategy
implements RebootNodeStrategy,
SuspendNodeStrategy,
ResumeNodeStrategy {
    private final RimuHostingClient client;
    private final GetNodeMetadataStrategy getNode;

    @Inject
    protected RimuHostingLifeCycleStrategy(RimuHostingClient client, GetNodeMetadataStrategy getNode) {
        this.client = client;
        this.getNode = getNode;
    }

    @Override
    public NodeMetadata rebootNode(String id) {
        Long serverId = Long.parseLong(id);
        this.client.restartServer(serverId).getState();
        return this.getNode.getNode(id);
    }

    @Override
    public NodeMetadata suspendNode(String id) {
        throw new UnsupportedOperationException("suspend not supported");
    }

    @Override
    public NodeMetadata resumeNode(String id) {
        throw new UnsupportedOperationException("resume not supported");
    }
}

