/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.compute.suppliers;

import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.internal.VolumeImpl;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.rimuhosting.miro.RimuHostingClient;
import org.jclouds.rimuhosting.miro.domain.PricingPlan;

@Singleton
public class RimuHostingHardwareSupplier
implements Supplier<Set<? extends Hardware>> {
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final RimuHostingClient sync;
    private final Supplier<Set<? extends Location>> locations;

    @Inject
    RimuHostingHardwareSupplier(RimuHostingClient sync, @Memoized Supplier<Set<? extends Location>> locations) {
        this.sync = sync;
        this.locations = locations;
    }

    @Override
    public Set<? extends Hardware> get() {
        HashSet<Hardware> sizes = Sets.newHashSet();
        this.logger.debug(">> providing sizes", new Object[0]);
        for (final PricingPlan pricingPlan : this.sync.getPricingPlanList()) {
            try {
                Location location = Iterables.find((Iterable)this.locations.get(), new Predicate<Location>(){

                    @Override
                    public boolean apply(Location input) {
                        return input.getId().equals(pricingPlan.getDataCenter().getId());
                    }
                });
                sizes.add(new HardwareBuilder().ids(pricingPlan.getId()).location(location).processors(ImmutableList.of(new Processor(1.0, 1.0))).ram(pricingPlan.getRam()).volumes(ImmutableList.of(new VolumeImpl(Float.valueOf(pricingPlan.getDiskSize().intValue()), true, true))).build());
            }
            catch (NullPointerException e) {
                this.logger.warn("datacenter not present in " + pricingPlan.getId(), new Object[0]);
            }
        }
        this.logger.debug("<< sizes(%d)", sizes.size());
        return sizes;
    }
}

