/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.compute.suppliers;

import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.logging.Logger;
import org.jclouds.rimuhosting.miro.RimuHostingClient;
import org.jclouds.rimuhosting.miro.domain.Image;

@Singleton
public class RimuHostingImageSupplier
implements Supplier<Set<? extends org.jclouds.compute.domain.Image>> {
    public static final Pattern RIMU_PATTERN = Pattern.compile("([a-zA-Z]+) ?([0-9.]+) .*");
    private final RimuHostingClient sync;
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;

    @Inject
    RimuHostingImageSupplier(RimuHostingClient sync) {
        this.sync = sync;
    }

    @Override
    public Set<? extends org.jclouds.compute.domain.Image> get() {
        HashSet<org.jclouds.compute.domain.Image> images = Sets.newHashSet();
        this.logger.debug(">> providing images", new Object[0]);
        for (Image image : this.sync.getImageList()) {
            ImageBuilder builder = new ImageBuilder();
            builder.ids(image.getId() + "");
            builder.name(image.getDescription());
            builder.description(image.getDescription());
            builder.operatingSystem(this.parseOs(image));
            images.add(builder.build());
        }
        this.logger.debug("<< images(%d)", images.size());
        return images;
    }

    protected OperatingSystem parseOs(Image from) {
        OsFamily osFamily = null;
        String osName = from.getId();
        String osArch = null;
        String osVersion = null;
        String osDescription = from.getDescription();
        boolean is64Bit = from.getId().indexOf("64") != -1;
        Matcher matcher = RIMU_PATTERN.matcher(osDescription);
        if (matcher.find()) {
            try {
                osFamily = OsFamily.fromValue(matcher.group(1).toLowerCase());
                osVersion = matcher.group(2).toLowerCase();
            }
            catch (IllegalArgumentException e) {
                this.logger.debug("<< didn't match os(%s)", osDescription);
            }
        }
        return new OperatingSystem(osFamily, osName, osVersion, osArch, osDescription, is64Bit);
    }
}

