/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.compute.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;
import org.jclouds.location.suppliers.JustProvider;
import org.jclouds.rimuhosting.miro.RimuHostingClient;
import org.jclouds.rimuhosting.miro.domain.DataCenter;
import org.jclouds.rimuhosting.miro.domain.PricingPlan;

@Singleton
public class RimuHostingLocationSupplier
extends JustProvider {
    private final RimuHostingClient sync;
    private final Map<String, Set<String>> isoCodesById;

    @Inject
    RimuHostingLocationSupplier(@Iso3166 Set<String> isoCodes, @Provider String providerName, @Provider URI endpoint, RimuHostingClient sync, @Iso3166 Map<String, Set<String>> isoCodesById) {
        super(providerName, endpoint, isoCodes);
        this.sync = Preconditions.checkNotNull(sync, "sync");
        this.isoCodesById = Preconditions.checkNotNull(isoCodesById, "isoCodesById");
    }

    @Override
    public Set<? extends Location> get() {
        ImmutableSet.Builder locations = ImmutableSet.builder();
        Iterable<DataCenter> list = Iterables.filter(Iterables.transform(this.sync.getPricingPlanList(), new Function<PricingPlan, DataCenter>(){

            @Override
            public DataCenter apply(PricingPlan arg0) {
                return arg0.getDataCenter();
            }
        }), Predicates.notNull());
        Location provider = (Location)Iterables.getOnlyElement(super.get());
        if (Iterables.size(list) == 0) {
            locations.add(provider);
        } else {
            for (DataCenter from : list) {
                LocationBuilder builder = new LocationBuilder().scope(LocationScope.ZONE).id(from.getId()).description(from.getName()).parent(provider);
                if (this.isoCodesById.containsKey(from.getId())) {
                    builder.iso3166Codes((Iterable<String>)this.isoCodesById.get(from.getId()));
                }
                locations.add(builder.build());
            }
        }
        return locations.build();
    }
}

