/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.config;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.date.DateService;
import org.jclouds.http.RequiresHttp;
import org.jclouds.json.config.GsonModule;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.config.RestClientModule;
import org.jclouds.rimuhosting.miro.RimuHostingAsyncClient;
import org.jclouds.rimuhosting.miro.RimuHostingClient;

@RequiresHttp
@ConfiguresRestClient
public class RimuHostingRestClientModule
extends RestClientModule<RimuHostingClient, RimuHostingAsyncClient> {
    public RimuHostingRestClientModule() {
        super(RimuHostingClient.class, RimuHostingAsyncClient.class);
    }

    @Override
    protected void configure() {
        this.bind(GsonModule.DateAdapter.class).to(RimuIso8601DateAdapter.class);
        super.configure();
    }

    @Singleton
    public static class RimuIso8601DateAdapter
    extends GsonModule.DateAdapter {
        private final DateService dateService;
        private final GsonModule.PropertiesAdapter propertiesAdapter;

        @Inject
        private RimuIso8601DateAdapter(DateService dateService, GsonModule.PropertiesAdapter propertiesAdapter) {
            this.dateService = dateService;
            this.propertiesAdapter = propertiesAdapter;
        }

        @Override
        public void write(JsonWriter writer, Date value) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            String isoFormat = this.propertiesAdapter.read(in).getProperty("iso_format");
            if (isoFormat != null) {
                return this.dateService.iso8601SecondsDateParse(isoFormat);
            }
            return null;
        }
    }
}

