/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rimuhosting.miro.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.SortedSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.rimuhosting.miro.domain.Image;
import org.jclouds.rimuhosting.miro.domain.internal.RimuHostingResponse;

@Singleton
public class ParseImagesFromJsonResponse
implements Function<HttpResponse, SortedSet<Image>> {
    private final ParseJson<Map<String, DistroResponse>> json;

    @Inject
    ParseImagesFromJsonResponse(ParseJson<Map<String, DistroResponse>> json) {
        this.json = json;
    }

    @Override
    public SortedSet<Image> apply(HttpResponse arg0) {
        return Iterables.get(this.json.apply(arg0).values(), 0).distro_infos;
    }

    private static class DistroResponse
    extends RimuHostingResponse {
        private SortedSet<Image> distro_infos;

        private DistroResponse() {
        }
    }
}

