/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.binders;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.binders.BindMapToHeadersWithPrefix;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.rest.Binder;
import org.jclouds.s3.domain.S3Object;

@Singleton
public class BindS3ObjectMetadataToRequest
implements Binder {
    protected final BindMapToHeadersWithPrefix metadataPrefixer;

    @Inject
    public BindS3ObjectMetadataToRequest(BindMapToHeadersWithPrefix metadataPrefixer) {
        this.metadataPrefixer = Preconditions.checkNotNull(metadataPrefixer, "metadataPrefixer");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        Preconditions.checkArgument(Preconditions.checkNotNull(input, "input") instanceof S3Object, "this binder is only valid for S3Object!, not %s", input);
        Preconditions.checkNotNull(request, "request");
        S3Object s3Object = (S3Object)S3Object.class.cast(input);
        Preconditions.checkArgument(s3Object.getMetadata().getKey() != null, "s3Object.getMetadata().getKey() must be set!");
        Preconditions.checkArgument(s3Object.getPayload().getContentMetadata().getContentLength() != null, "contentLength must be set, streaming not supported");
        Preconditions.checkArgument(s3Object.getPayload().getContentMetadata().getContentLength() <= 0x140000000L, "maximum size for put object is 5GB");
        request = this.metadataPrefixer.bindToRequest(request, s3Object.getMetadata().getUserMetadata());
        if (s3Object.getMetadata().getCacheControl() != null) {
            request = ModifyRequest.replaceHeader(request, "Cache-Control", s3Object.getMetadata().getCacheControl());
        }
        return request;
    }
}

