/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.domain.BucketMetadata;

@Singleton
public class LocationFromBucketLocation
implements Function<BucketMetadata, Location> {
    private final Location onlyLocation;
    private final Supplier<Set<? extends Location>> locations;
    private final S3Client client;
    @Resource
    protected Logger logger = Logger.NULL;

    @Inject
    LocationFromBucketLocation(S3Client client, @Memoized Supplier<Set<? extends Location>> locations) {
        this.client = client;
        this.onlyLocation = locations.get().size() == 1 ? (Location)Iterables.get((Iterable)locations.get(), 0) : null;
        this.locations = locations;
    }

    @Override
    public Location apply(BucketMetadata from) {
        if (this.onlyLocation != null) {
            return this.onlyLocation;
        }
        try {
            Set<? extends Location> locations = this.locations.get();
            final String region = this.client.getBucketLocation(from.getName());
            assert (region != null) : String.format("could not get region for %s", from.getName());
            if (region != null) {
                try {
                    return Iterables.find(locations, new Predicate<Location>(){

                        @Override
                        public boolean apply(Location input) {
                            return input.getId().equalsIgnoreCase(region.toString());
                        }
                    });
                }
                catch (NoSuchElementException e) {
                    this.logger.error("could not get location for region %s in %s", region, locations);
                }
            } else {
                this.logger.error("could not get region for %s", from.getName());
            }
        }
        catch (ContainerNotFoundException e) {
            this.logger.error(e, "could not get region for %s, as service suggests the bucket doesn't exist", from.getName());
        }
        return null;
    }
}

