/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.io.InputSuppliers;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.s3.Bucket;
import org.jclouds.util.Strings2;

@Singleton
public class RequestAuthorizeSignature
implements HttpRequestFilter,
RequestSigner {
    private static final Predicate<Annotation> ANNOTATIONTYPE_BUCKET = new Predicate<Annotation>(){

        @Override
        public boolean apply(Annotation input) {
            return input.annotationType().equals(Bucket.class);
        }
    };
    private final String[] firstHeadersToSign = new String[]{"Date"};
    public static Set<String> SIGNED_PARAMETERS = ImmutableSet.of("acl", "torrent", "logging", "location", "policy", "requestPayment", new String[]{"versioning", "versions", "versionId", "notification", "uploadId", "uploads", "partNumber", "website", "response-content-type", "response-content-language", "response-expires", "response-cache-control", "response-content-disposition", "response-content-encoding"});
    private final SignatureWire signatureWire;
    private final String accessKey;
    private final String secretKey;
    private final Provider<String> timeStampProvider;
    private final Crypto crypto;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;
    private final String authTag;
    private final String headerTag;
    private final String servicePath;
    private final boolean isVhostStyle;

    @Inject
    public RequestAuthorizeSignature(SignatureWire signatureWire, @Named(value="jclouds.aws.auth.tag") String authTag, @Named(value="jclouds.s3.virtual-host-buckets") boolean isVhostStyle, @Named(value="jclouds.s3.service-path") String servicePath, @Named(value="jclouds.aws.header.tag") String headerTag, @Named(value="jclouds.identity") String accessKey, @Named(value="jclouds.credential") String secretKey, @TimeStamp Provider<String> timeStampProvider, Crypto crypto, HttpUtils utils) {
        this.isVhostStyle = isVhostStyle;
        this.servicePath = servicePath;
        this.headerTag = headerTag;
        this.authTag = authTag;
        this.signatureWire = signatureWire;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.timeStampProvider = timeStampProvider;
        this.crypto = crypto;
        this.utils = utils;
    }

    @Override
    public HttpRequest filter(HttpRequest request) throws HttpException {
        request = this.replaceDateHeader(request);
        String signature = this.calculateSignature(this.createStringToSign(request));
        request = this.replaceAuthorizationHeader(request, signature);
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    HttpRequest replaceAuthorizationHeader(HttpRequest request, String signature) {
        request = ModifyRequest.replaceHeader(request, "Authorization", this.authTag + " " + this.accessKey + ":" + signature);
        return request;
    }

    HttpRequest replaceDateHeader(HttpRequest request) {
        request = ModifyRequest.replaceHeader(request, "Date", this.timeStampProvider.get());
        return request;
    }

    @Override
    public String createStringToSign(HttpRequest request) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        TreeMultimap<String, String> canonicalizedHeaders = TreeMultimap.create();
        StringBuilder buffer = new StringBuilder();
        this.appendMethod(request, buffer);
        this.appendPayloadMetadata(request, buffer);
        this.appendHttpHeaders(request, canonicalizedHeaders);
        if (canonicalizedHeaders.containsKey("x-" + this.headerTag + "-date")) {
            canonicalizedHeaders.removeAll("date");
        }
        this.appendAmzHeaders(canonicalizedHeaders, buffer);
        if (this.isVhostStyle) {
            this.appendBucketName(request, buffer);
        }
        this.appendUriPath(request, buffer);
        if (this.signatureWire.enabled()) {
            this.signatureWire.output(buffer.toString());
        }
        return buffer.toString();
    }

    String calculateSignature(String toSign) throws HttpException {
        String signature = this.sign(toSign);
        if (this.signatureWire.enabled()) {
            this.signatureWire.input(Strings2.toInputStream(signature));
        }
        return signature;
    }

    @Override
    public String sign(String toSign) {
        String signature;
        try {
            signature = CryptoStreams.base64(CryptoStreams.mac(InputSuppliers.of(toSign), this.crypto.hmacSHA1(this.secretKey.getBytes())));
        }
        catch (Exception e) {
            throw new HttpException("error signing request", e);
        }
        return signature;
    }

    void appendMethod(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getMethod()).append("\n");
    }

    @VisibleForTesting
    void appendAmzHeaders(SortedSetMultimap<String, String> canonicalizedHeaders, StringBuilder toSign) {
        for (Map.Entry header : canonicalizedHeaders.entries()) {
            String key = (String)header.getKey();
            if (!key.startsWith("x-" + this.headerTag + "-")) continue;
            toSign.append(String.format("%s:%s\n", key.toLowerCase(), header.getValue()));
        }
    }

    void appendPayloadMetadata(HttpRequest request, StringBuilder buffer) {
        buffer.append(request.getPayload() == null ? this.utils.valueOrEmpty(request.getFirstHeaderOrNull("Content-MD5")) : this.utils.valueOrEmpty(request.getPayload() == null ? null : request.getPayload().getContentMetadata().getContentMD5())).append("\n");
        buffer.append(this.utils.valueOrEmpty(request.getPayload() == null ? request.getFirstHeaderOrNull("Content-Type") : request.getPayload().getContentMetadata().getContentType())).append("\n");
        for (String header : this.firstHeadersToSign) {
            buffer.append(this.valueOrEmpty(request.getHeaders().get(header))).append("\n");
        }
    }

    @VisibleForTesting
    void appendHttpHeaders(HttpRequest request, SortedSetMultimap<String, String> canonicalizedHeaders) {
        Multimap<String, String> headers = request.getHeaders();
        for (Map.Entry<String, String> header : headers.entries()) {
            String key;
            if (header.getKey() == null || !(key = header.getKey().toString().toLowerCase(Locale.getDefault())).equalsIgnoreCase("Content-Type") && !key.equalsIgnoreCase("Content-MD5") && !key.equalsIgnoreCase("Date") && !key.startsWith("x-" + this.headerTag + "-")) continue;
            canonicalizedHeaders.put(key, header.getValue());
        }
    }

    @VisibleForTesting
    void appendBucketName(HttpRequest req, StringBuilder toSign) {
        Preconditions.checkArgument(req instanceof GeneratedHttpRequest, "this should be a generated http request");
        GeneratedHttpRequest request = (GeneratedHttpRequest)GeneratedHttpRequest.class.cast(req);
        String bucketName = null;
        for (int i = 0; i < request.getJavaMethod().getParameterAnnotations().length; ++i) {
            if (!Iterables.any(Arrays.asList(request.getJavaMethod().getParameterAnnotations()[i]), ANNOTATIONTYPE_BUCKET)) continue;
            bucketName = (String)request.getArgs().get(i);
            break;
        }
        if (bucketName != null) {
            toSign.append(this.servicePath).append(bucketName);
        }
    }

    @VisibleForTesting
    void appendUriPath(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getEndpoint().getRawPath());
        if (request.getEndpoint().getQuery() != null) {
            Multimap<String, String> params = ModifyRequest.parseQueryToMap(request.getEndpoint().getQuery());
            int separator = 63;
            for (String paramName : Ordering.natural().sortedCopy(params.keySet())) {
                if (!SIGNED_PARAMETERS.contains(paramName)) continue;
                toSign.append((char)separator).append(paramName);
                String paramValue = Iterables.get(params.get(paramName), 0);
                if (paramValue != null) {
                    toSign.append("=").append(paramValue);
                }
                separator = 38;
            }
        }
    }

    private String valueOrEmpty(Collection<String> collection) {
        return collection != null && collection.size() >= 1 ? collection.iterator().next() : "";
    }
}

