/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Function;
import javax.inject.Singleton;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.util.Throwables2;

@Singleton
public class ReturnFalseIfBucketAlreadyOwnedByYouOrIllegalState
implements Function<Exception, Boolean> {
    @Override
    public Boolean apply(Exception from) {
        AWSResponseException exception = Throwables2.getFirstThrowableOfType(from, AWSResponseException.class);
        if (exception != null && exception.getError() != null && exception.getError().getCode().equals("BucketAlreadyOwnedByYou")) {
            return false;
        }
        if (Throwables2.getFirstThrowableOfType(from, IllegalStateException.class) != null) {
            return false;
        }
        return (Boolean)Boolean.class.cast(Throwables2.propagateOrNull(from));
    }
}

