/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.handlers;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.core.UriBuilder;
import org.jclouds.aws.domain.AWSError;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.handlers.BackoffLimitedRetryHandler;
import org.jclouds.http.handlers.RedirectionRetryHandler;

@Singleton
public class S3RedirectionRetryHandler
extends RedirectionRetryHandler {
    private final AWSUtils utils;

    @Inject
    public S3RedirectionRetryHandler(Provider<UriBuilder> uriBuilderProvider, BackoffLimitedRetryHandler backoffHandler, AWSUtils utils) {
        super(uriBuilderProvider, backoffHandler);
        this.utils = utils;
    }

    @Override
    public boolean shouldRetryRequest(HttpCommand command, HttpResponse response) {
        if (response.getFirstHeaderOrNull("Location") == null && (response.getStatusCode() == 301 || response.getStatusCode() == 307)) {
            if (command.getCurrentRequest().getMethod().equals("HEAD")) {
                command.incrementRedirectCount();
                command.setCurrentRequest(command.getCurrentRequest().toBuilder().method("GET").build());
                return true;
            }
            command.incrementRedirectCount();
            HttpUtils.closeClientButKeepContentStream(response);
            AWSError error = this.utils.parseAWSErrorFromContent(command.getCurrentRequest(), response);
            String host = error.getDetails().get("Endpoint");
            if (host != null) {
                if (host.equals(command.getCurrentRequest().getEndpoint().getHost())) {
                    return this.backoffHandler.shouldRetryRequest(command, response);
                }
                UriBuilder builder = ((UriBuilder)this.uriBuilderProvider.get()).uri(command.getCurrentRequest().getEndpoint());
                builder.host(host);
                command.setCurrentRequest(command.getCurrentRequest().toBuilder().endpoint(builder.build(new Object[0])).build());
                return true;
            }
            return false;
        }
        return super.shouldRetryRequest(command, response);
    }
}

