/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.binders;

import com.google.common.base.Preconditions;
import com.jamesmurty.utils.XMLBuilder;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.savvis.vpdc.domain.FirewallRule;

@Singleton
public class BindCaptureVAppTemplateToXmlPayload
extends BindToStringPayload
implements MapBinder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("BindFirewallRuleToXmlPayload needs parameters");
    }

    protected URI findVAppURIInArgsOrNull(GeneratedHttpRequest<?> gRequest) {
        for (Object arg : gRequest.getArgs()) {
            if (arg instanceof URI) {
                return (URI)arg;
            }
            if (!(arg instanceof FirewallRule[])) continue;
            URI[] rules = (URI[])arg;
            return rules.length > 0 ? rules[0] : null;
        }
        return null;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        Preconditions.checkArgument(Preconditions.checkNotNull(request, "request") instanceof GeneratedHttpRequest, "this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState(gRequest.getArgs() != null, "args should be initialized at this point");
        request = super.bindToRequest(request, this.generateXml(this.findVAppURIInArgsOrNull(gRequest)));
        request.getPayload().getContentMetadata().setContentType("application/xml");
        return request;
    }

    public String generateXml(URI vAppURI) {
        Preconditions.checkNotNull(vAppURI, "vAppURI");
        try {
            XMLBuilder rootBuilder = this.buildRoot();
            this.addSourceSection(rootBuilder, vAppURI);
            Properties outputProperties = new Properties();
            return rootBuilder.asString(outputProperties);
        }
        catch (Exception e) {
            return null;
        }
    }

    void addSourceSection(XMLBuilder rootBuilder, URI vAppURI) {
        rootBuilder.e("Description").t("Save Template");
        rootBuilder.e("Source").a("href", vAppURI.toString());
    }

    protected XMLBuilder buildRoot() throws ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder rootBuilder = XMLBuilder.create("CaptureVAppParams").a("xmlns", "http://schemas.api.sandbox.symphonyVPDC.savvis.net/vpdci").a("name", "CaptureTemplate");
        return rootBuilder;
    }

    protected String ifNullDefaultTo(String value, String defaultValue) {
        return value != null ? value : Preconditions.checkNotNull(defaultValue, "defaultValue");
    }
}

