/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.binders;

import com.google.common.base.Preconditions;
import com.jamesmurty.utils.XMLBuilder;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.savvis.vpdc.domain.FirewallRule;

@Singleton
public class BindCloneVMToXmlPayload
extends BindToStringPayload
implements MapBinder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("BindFirewallRuleToXmlPayload needs parameters");
    }

    protected URI findVAppURIInArgsOrNull(GeneratedHttpRequest<?> gRequest) {
        for (Object arg : gRequest.getArgs()) {
            if (arg instanceof URI) {
                return (URI)arg;
            }
            if (!(arg instanceof FirewallRule[])) continue;
            URI[] rules = (URI[])arg;
            return rules.length > 0 ? rules[0] : null;
        }
        return null;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        Preconditions.checkArgument(Preconditions.checkNotNull(request, "request") instanceof GeneratedHttpRequest, "this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState(gRequest.getArgs() != null, "args should be initialized at this point");
        request = super.bindToRequest(request, this.generateXml(this.findVAppURIInArgsOrNull(gRequest), postParams.get("name"), postParams.get("networkTierName")));
        request.getPayload().getContentMetadata().setContentType("application/xml");
        return request;
    }

    public String generateXml(URI vAppURI, String newVAppName, String networkTierName) {
        Preconditions.checkNotNull(vAppURI, "vAppURI");
        try {
            XMLBuilder rootBuilder = this.buildRoot(newVAppName);
            this.addVAppSection(rootBuilder, vAppURI, networkTierName);
            Properties outputProperties = new Properties();
            return rootBuilder.asString(outputProperties);
        }
        catch (Exception e) {
            return null;
        }
    }

    void addVAppSection(XMLBuilder rootBuilder, URI vAppURI, String networkTierName) {
        String vAppStr = "vApp/";
        rootBuilder.e("Description").t(networkTierName.replace("-", " "));
        String genericVAppURI = vAppURI.toString().substring(0, vAppURI.toString().indexOf("vApp") + vAppStr.length());
        rootBuilder.e("VApp").a("href", genericVAppURI).a("type", "application/vnd.vmware.vcloud.vApp+xml");
    }

    protected XMLBuilder buildRoot(String newVAppName) throws ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder rootBuilder = XMLBuilder.create("CloneVAppParams").a("xmlns", "http://www.vmware.com/vcloud/v0.8").a("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance").a("name", newVAppName).a("deploy", "true").a("powerOn", "true").a("xsi:schemaLocation", "http://www.vmware.com/vcloud/v0.8 https://api.symphonyvpdc.savvis.net/ns/vcloud.xsd");
        return rootBuilder;
    }

    protected String ifNullDefaultTo(String value, String defaultValue) {
        return value != null ? value : Preconditions.checkNotNull(defaultValue, "defaultValue");
    }
}

