/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.binders;

import com.google.common.base.Preconditions;
import com.jamesmurty.utils.XMLBuilder;
import java.util.Map;
import java.util.Properties;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.savvis.vpdc.domain.FirewallRule;

@Singleton
public class BindFirewallRuleToXmlPayload
extends BindToStringPayload
implements MapBinder {
    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("BindFirewallRuleToXmlPayload needs parameters");
    }

    protected FirewallRule findRuleInArgsOrNull(GeneratedHttpRequest<?> gRequest) {
        for (Object arg : gRequest.getArgs()) {
            if (arg instanceof FirewallRule) {
                return (FirewallRule)arg;
            }
            if (!(arg instanceof FirewallRule[])) continue;
            FirewallRule[] rules = (FirewallRule[])arg;
            return rules.length > 0 ? rules[0] : null;
        }
        return null;
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, String> postParams) {
        Preconditions.checkArgument(Preconditions.checkNotNull(request, "request") instanceof GeneratedHttpRequest, "this binder is only valid for GeneratedHttpRequests!");
        GeneratedHttpRequest gRequest = (GeneratedHttpRequest)request;
        Preconditions.checkState(gRequest.getArgs() != null, "args should be initialized at this point");
        request = super.bindToRequest(request, this.generateXml(this.findRuleInArgsOrNull(gRequest)));
        request.getPayload().getContentMetadata().setContentType("application/xml");
        return request;
    }

    public String generateXml(FirewallRule firewallRule) {
        Preconditions.checkNotNull(firewallRule, "FirewallRule");
        try {
            XMLBuilder rootBuilder = this.buildRoot();
            this.addFirewallRuleSection(rootBuilder, firewallRule);
            Properties outputProperties = new Properties();
            outputProperties.put("omit-xml-declaration", "yes");
            return rootBuilder.asString(outputProperties);
        }
        catch (Exception e) {
            return null;
        }
    }

    void addFirewallRuleSection(XMLBuilder rootBuilder, FirewallRule firewallRule) {
        XMLBuilder firewallRuleBuilder = rootBuilder.e("svvs:FirewallRule");
        firewallRuleBuilder.e("svvs:IsEnabled").t(firewallRule.isEnabled() ? "true" : "false");
        firewallRuleBuilder.e("svvs:Description").t("Server Tier Firewall Rule");
        firewallRuleBuilder.e("svvs:Type").t(firewallRule.getFirewallType());
        firewallRuleBuilder.e("svvs:Log").t(firewallRule.isLogged() ? "yes" : "no");
        firewallRuleBuilder.e("svvs:Policy").t(firewallRule.getPolicy());
        firewallRuleBuilder.e("svvs:Protocols").e("svvs:" + firewallRule.getProtocol()).t("true").up().up();
        firewallRuleBuilder.e("svvs:Port").t(firewallRule.getPort());
        firewallRuleBuilder.e("svvs:Destination").t(firewallRule.getDestination());
        firewallRuleBuilder.e("svvs:Source").t(firewallRule.getSource());
    }

    protected XMLBuilder buildRoot() throws ParserConfigurationException, FactoryConfigurationError {
        XMLBuilder rootBuilder = XMLBuilder.create("svvs:FirewallService").a("xmlns:common", "http://schemas.dmtf.org/wbem/wscim/1/common").a("xmlns:vApp", "http://www.vmware.com/vcloud/v0.8").a("xmlns:rasd", "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ResourceAllocationSettingData").a("xmlns:vssd", "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_VirtualSystemSettingData").a("xmlns:ovf", "http://schemas.dmtf.org/ovf/envelope/1").a("xmlns:svvs", "http://schemas.api.sandbox.symphonyVPDC.savvis.net/vpdci");
        return rootBuilder;
    }

    protected String ifNullDefaultTo(String value, String defaultValue) {
        return value != null ? value : Preconditions.checkNotNull(defaultValue, "defaultValue");
    }
}

