/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.jamesmurty.utils.XMLBuilder;
import javax.inject.Singleton;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.savvis.vpdc.binders.BaseBindVMSpecToXmlPayload;
import org.jclouds.savvis.vpdc.domain.VMSpec;

@Singleton
public class BindVMSpecsToXmlPayload
extends BaseBindVMSpecToXmlPayload<Iterable<VMSpec>> {
    @Override
    protected Iterable<VMSpec> findSpecInArgsOrNull(GeneratedHttpRequest<?> gRequest) {
        for (Object arg : gRequest.getArgs()) {
            if (!(arg instanceof Iterable)) continue;
            Iterable specs = (Iterable)arg;
            Preconditions.checkArgument(Iterables.size(specs) > 0, "At least one VMSpec must be included in the argument list");
            return specs;
        }
        throw new IllegalArgumentException("Iterbable<VMSpec> must be included in the argument list");
    }

    @Override
    protected void bindSpec(Iterable<VMSpec> specs, XMLBuilder rootBuilder) throws ParserConfigurationException, FactoryConfigurationError {
        rootBuilder.a("name", "");
        XMLBuilder specBuilder = this.buildChildren(rootBuilder);
        for (VMSpec spec : specs) {
            this.checkSpec(spec);
            XMLBuilder vAppBuilder = this.buildRootForName(specBuilder, spec.getName());
            this.addOperatingSystemAndVirtualHardware(spec, vAppBuilder);
        }
    }
}

