/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.savvis.vpdc.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.CIMOperatingSystem;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.domain.Location;
import org.jclouds.savvis.vpdc.VPDCAsyncClient;
import org.jclouds.savvis.vpdc.VPDCClient;
import org.jclouds.savvis.vpdc.compute.functions.CIMOperatingSystemToImage;
import org.jclouds.savvis.vpdc.compute.functions.NetworkToLocation;
import org.jclouds.savvis.vpdc.compute.functions.VMSpecToHardware;
import org.jclouds.savvis.vpdc.compute.functions.VMToNodeMetadata;
import org.jclouds.savvis.vpdc.compute.strategy.VPDCComputeServiceAdapter;
import org.jclouds.savvis.vpdc.compute.suppliers.FirstNetwork;
import org.jclouds.savvis.vpdc.domain.Network;
import org.jclouds.savvis.vpdc.domain.VM;
import org.jclouds.savvis.vpdc.domain.VMSpec;

public class VPDCComputeServiceContextModule
extends ComputeServiceAdapterContextModule<VPDCClient, VPDCAsyncClient, VM, VMSpec, CIMOperatingSystem, Network> {
    public VPDCComputeServiceContextModule() {
        super(VPDCClient.class, VPDCAsyncClient.class);
    }

    @Override
    protected TemplateBuilder provideTemplate(Injector injector, TemplateBuilder template) {
        return template.osFamily(OsFamily.RHEL).os64Bit(true);
    }

    @Override
    protected void configure() {
        super.configure();
        this.bind(new TypeLiteral<ComputeServiceAdapter<VM, VMSpec, CIMOperatingSystem, Network>>(){}).to(VPDCComputeServiceAdapter.class);
        this.bind(new TypeLiteral<Function<VM, NodeMetadata>>(){}).to(VMToNodeMetadata.class);
        this.bind(new TypeLiteral<Function<CIMOperatingSystem, Image>>(){}).to(CIMOperatingSystemToImage.class);
        this.bind(new TypeLiteral<Function<VMSpec, Hardware>>(){}).to(VMSpecToHardware.class);
        this.bind(new TypeLiteral<Function<Network, Location>>(){}).to(NetworkToLocation.class);
        this.bind(new TypeLiteral<Supplier<Location>>(){}).to(FirstNetwork.class);
    }
}

